package br.com.esec.icpm.libs.signature.response.handler;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import javax.activation.DataHandler;

import org.apache.commons.io.IOUtils;

import br.com.esec.icpm.libs.Server;
import br.com.esec.icpm.libs.signature.exceptions.InvalidSignatureException;
import br.com.esec.icpm.libs.signature.exceptions.RejectedSignatureException;
import br.com.esec.icpm.libs.signature.exceptions.SignatureException;
import br.com.esec.icpm.libs.signature.helper.attach.CadesAttachSignatureHelper;
import br.com.esec.icpm.libs.signature.helper.attach.PdfAttachSignatureHelper;
import br.com.esec.icpm.libs.signature.helper.attach.XadesAttachSignatureHelper;
import br.com.esec.icpm.server.factory.Status;

public abstract class BaseSignatureHandler implements SignatureHandler {

	protected long transactionId;
	protected Server server;

	public BaseSignatureHandler(Server server, long transactionId) {
		this.server = server;
		this.transactionId = transactionId;
	}

	public long transactionId() {
		return transactionId;
	}
	
	protected void saveCades(OutputStream signedDocument, InputStream signature) throws IOException {
		IOUtils.copy(signature, signedDocument);
	}

	protected void saveCades(InputStream originalDocument, OutputStream signedDocument, InputStream signature) throws IOException {
		saveCades(transactionId, originalDocument, signedDocument, signature);
	}
	
	protected void saveXades(InputStream originalDocument, OutputStream signedDocument, InputStream signature) throws IOException {
		saveXades(transactionId, originalDocument, signedDocument, signature);
	}

	protected void saveAdobePdf(InputStream originalPdf, OutputStream signedPdf, InputStream signature) {
		saveAdobePdf(transactionId, originalPdf, signedPdf, signature);
	}

	protected void saveCades(long docId, InputStream originalDocument, OutputStream signedDocument, InputStream signature) throws IOException {
		CadesAttachSignatureHelper.attach(docId, originalDocument, signature, signedDocument);
	}

	protected void saveXades(long docId, InputStream originalDocument, OutputStream signedDocument, InputStream signature) throws IOException {
		XadesAttachSignatureHelper.attach(docId, originalDocument, signature, signedDocument);
	}

	protected void saveAdobePdf(long docId, InputStream originalPdf, OutputStream signedPdf, InputStream signature) {
		PdfAttachSignatureHelper.attach(docId, originalPdf, signature, signedPdf);
	}

	protected InputStream parseSignature(int statusCode, final DataHandler signatureDataHandler) throws IOException {
		if (signatureDataHandler == null)
			return null;

		if (statusCode == Status.SIGNATURE_VALID.getCode()) {
			if (signatureDataHandler != null) {
				return new ByteArrayInputStream(IOUtils.toByteArray(signatureDataHandler.getInputStream()));
			}
		}
		return null;
	}

	protected void validateStatus(long transactionId, int statusCode, String statusMessage) throws SignatureException {
		Status status = Status.getByCode(statusCode);

		if (!status.isError())
			return;

		switch (status) {
		case SIGNATURE_INVALID:
			throw new InvalidSignatureException(transactionId, statusCode, statusMessage);
		case USER_CANCELED:
			throw new RejectedSignatureException(transactionId, statusCode, statusMessage);
		default:
			throw new SignatureException(transactionId, statusCode, statusMessage);
		}
	}
}