package br.com.esec.icpm.libs.signature.helper;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import br.com.esec.icpm.libs.Server;
import br.com.esec.icpm.libs.signature.ApWsFactory;
import br.com.esec.icpm.libs.signature.ApplicationProviderClient;

public class DownloadSignatureHelper {
	
	private static Logger log = LoggerFactory.getLogger(DownloadSignatureHelper.class);

	/**
	 * Download the document and write on the output stream.
	 * 
	 * <p> DONT CLOSE THE OUTPUT STREAM.
	 * 
	 * @param server
	 * @param transactionId
	 * @param out
	 * @throws IOException
	 */
	public static void downloadAttachedDocument(Server server, Long transactionId, OutputStream out) throws IOException {
		// TODO: Usar metodo download da interface.
		// Tem que mudar no Certillion. Vide: http://stackoverflow.com/questions/12239868/whats-the-correct-way-to-send-a-file-from-rest-web-service-to-client
		
		log.info("[TRANSACTION ID " + transactionId + "] Downloading attached signature " + transactionId + "...");
		
		ApplicationProviderClient restService = (ApplicationProviderClient) ApWsFactory.getInstance().getRestService(server);
		InputStream in = restService.downloadSignedDocumentCustomized(transactionId);

		try {
			IOUtils.copy(in, out);
			log.info("[TRANSACTION ID " + transactionId + "] Attached signature downloaded.");
		} finally {
			IOUtils.closeQuietly(in);
		}
	}
	
}
