package br.com.esec.icpm.libs.signature;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import br.com.esec.icpm.libs.Configurable;
import br.com.esec.icpm.libs.Server;
import br.com.esec.icpm.server.ws.SignaturePolicyType;

public class SignatureRequest {

	private static Logger log = LoggerFactory.getLogger(SignatureRequest.class);
	
	String identifier;
	boolean testMode;
	SignaturePolicyType policyType = SignaturePolicyType.AD_RB;
	Server server;
	Long apId = 0l;
	
	SignatureOptions options = new SignatureOptions();
	
	public SignatureRequest(Server server) {
		this.server = server;
	}
	
	public SignatureRequest testMode() {
		testMode = true;
		return this;
	}
	
	public SignatureRequest apId(Long apId) {
		this.apId = apId;
		return this;
	}

	public SignatureRequest toUser(String identifier) {
		this.identifier = identifier;
		return this;
	}
	
	public SimpleSignatureRequest simple() {
		return new SimpleSignatureRequest(this);
	}
	
	public BatchSignatureRequest batch() {
		return new BatchSignatureRequest(this);
	}

	public SignatureRequest adRb() {
		policyType = SignaturePolicyType.AD_RB;
		return this;
	}

	public SignatureRequest adRt() {
		policyType = SignaturePolicyType.AD_RT;
		return this;
	}

	public SignatureRequest adRc() {
		policyType = SignaturePolicyType.AD_RC;
		return this;
	}

	public SignatureRequest adRv() {
		policyType = SignaturePolicyType.AD_RV;
		return this;
	}

	public SignatureRequest adRa() {
		policyType = SignaturePolicyType.AD_RA;
		return this;
	}
	
	/**
	 * Set to use the production server.
	 * This server need to put a keystore.
	 * The production host is a DEFAULT value. 
	 * {@link Server#PRODUCTION}
	 * @return
	 */
	public SignatureRequest useProductionServer() {
		this.server = Server.PRODUCTION;
		return this;
	}
	
	/**
	 * Set to use the server of test. This server have many limitation. Check on us site. 
	 * {@link Server#TEST}
	 * @return
	 */
	public SignatureRequest useTestServer() {
		this.server = Server.TEST;
		return this;
	}
	
	/**
	 * Set to use an arbitrary server. 
	 * @param host 
	 * @param secure
	 * @return
	 */
	public SignatureRequest useArbitraryServer(String host, boolean secure) {
		this.server = new Server(host, secure);
		return this;
	}

	public SignatureOptions options() {
		return options;
	}

}
