package br.com.esec.icpm.libs.signature;

import br.com.esec.icpm.server.ws.AlgorithmCertificateFilterType;
import br.com.esec.icpm.server.ws.AlgorithmType;
import br.com.esec.icpm.server.ws.CertificateFilterType;
import br.com.esec.icpm.server.ws.CertificateFiltersType;
import br.com.esec.icpm.server.ws.ForceHardwareFilterType;

public class SignatureOptions {
	
	CertificateFiltersType certificateFilters;

	public SignatureOptions onlyRsa() {
		addFilter(new AlgorithmCertificateFilterType(AlgorithmType.RSA));
		return this;
	}
	
	public SignatureOptions onlyEcdsa() {
		addFilter(new AlgorithmCertificateFilterType(AlgorithmType.ECC));
		return this;
	}

	public void forceHardware() {
		addFilter(new ForceHardwareFilterType(true));
	}
	
	private void addFilter(CertificateFilterType filter) {
		if (certificateFilters == null)
			certificateFilters = new CertificateFiltersType();
		certificateFilters.addFilter(filter);
	}
}
