package br.com.esec.icpm.libs;

import java.util.HashMap;
import java.util.Map;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import br.com.esec.icpm.signer.ws.rest.SslUtils;

public class DefaultHttpClientBuilder implements HttpClientBuilder {

	private static Logger log = LoggerFactory.getLogger(DefaultHttpClientBuilder.class);
	
	@Override
	public Client getClient(Server server) {
		return getClientBuilder(server).build();
	}

	private Map<Server, ClientBuilder> builders = new HashMap<Server, ClientBuilder>();

	private ClientBuilder getClientBuilder(Server server) {
		if (!builders.containsKey(server)) {
			log.info("Configuring a HTTP client builder to server " + server.getHost() + "...");

			ClientBuilder builder = ClientBuilder.newBuilder();

			if (server.isSecure())
				SslUtils.config(builder);
			builders.put(server, builder);
			log.info("HTTP client builder to server " + server.getHost() + " configured.");
		}
		return builders.get(server);
	}

}
