package br.com.esec.icpm.libs;

import br.com.esec.icpm.signer.security.SecurityConfig;

public class Configurable {

	private String keystorePath;
	private String keystoreType;
	private String keystorePassword;
	private String keyAlias;
	private String truststorePath;
	private String truststoreType;
	private String truststorePassword;
	private Boolean allowAllHosts;
	
	private Server server;
	
	public void done() {
		SecurityConfig.setKeystorePath(keystorePath);
		SecurityConfig.setKeystoreType(keystoreType);
		SecurityConfig.setKeystorePassword(keystorePassword);
		SecurityConfig.setKeyAlias(keyAlias);
		SecurityConfig.setTruststorePath(truststorePath);
		SecurityConfig.setTruststoreType(truststoreType);
		SecurityConfig.setTruststorePassword(truststorePassword);
		SecurityConfig.setAllowAllHosts(allowAllHosts);
		
		SecurityConfig.validate();
		
		if (server != null)
			Certillion.server = server;
	}
	
	
	/**
	 * Set to use the production server.
	 * This server need to put a keystore.
	 * The production host is a DEFAULT value. 
	 * {@link Server#PRODUCTION}
	 * @return
	 */
	public Configurable useProductionServer() {
		this.server = Server.PRODUCTION;
		return this;
	}
	
	/**
	 * Set to use the server of test. This server have many limitation. Check on us site. 
	 * {@link Server#TEST}
	 * @return
	 */
	public Configurable useTestServer() {
		this.server = Server.TEST;
		return this;
	}
	
	/**
	 * Set to use an arbitrary server. 
	 * @param host 
	 * @param secure
	 * @return
	 */
	public Configurable useArbitraryServer(String host, boolean secure) {
		this.server = new Server(host, secure);
		return this;
	}
	
	/**
	 * Set to use an arbitrary server. 
	 * @param host 
	 * @param secure
	 * @param soapWsUri 
	 * @param restWsUri 
	 * @return
	 */
	public Configurable useArbitraryServer(String host, boolean secure, String soapWsUri, String restWsUri) {
		this.server = new Server(host, secure, soapWsUri, restWsUri);
		return this;
	}

	public Configurable keystorePath(String keystorePath) {
		this.keystorePath = keystorePath;
		return this;
	}

	public Configurable keystoreType(String keystoreType) {
		this.keystoreType = keystoreType;
		return this;
	}

	public Configurable keystorePassword(String keystorePassword) {
		this.keystorePassword = keystorePassword;
		return this;
	}

	public Configurable keyAlias(String keyAlias) {
		this.keyAlias = keyAlias;
		return this;
	}

	public Configurable truststorePath(String truststorePath) {
		this.truststorePath = truststorePath;
		return this;
	}

	public Configurable truststoreType(String truststoreType) {
		this.truststoreType = truststoreType;
		return this;
	}

	public Configurable truststorePassword(String truststorePassword) {
		this.truststorePassword = truststorePassword;
		return this;
	}

	public Configurable allowAllHosts(boolean allowAllHosts) {
		this.allowAllHosts = allowAllHosts;
		return this;
	}

}
