/*
 * Decompiled with CFR 0.152.
 */
package br.com.esec.icpm.libs.signature.response.polling;

import br.com.esec.icpm.libs.Server;
import br.com.esec.icpm.libs.signature.helper.RequestBatchSignatureHelper;
import br.com.esec.icpm.libs.signature.helper.RequestStatusHelper;
import br.com.esec.icpm.libs.signature.response.Futures;
import br.com.esec.icpm.libs.signature.response.polling.BasePollingService;
import br.com.esec.icpm.mss.ws.BatchSignatureTIDsRespType;
import br.com.esec.icpm.server.factory.Status;
import br.com.esec.icpm.server.ws.ICPMException;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchPollingService
extends BasePollingService<BatchSignatureTIDsRespType> {
    private static Logger log = LoggerFactory.getLogger(RequestBatchSignatureHelper.class);
    private static BatchPollingService instance;

    public static BatchPollingService getInstance() {
        if (instance == null) {
            instance = new BatchPollingService();
        }
        return instance;
    }

    public ListenableFuture<BatchSignatureTIDsRespType> status(Server server, long transactionId) {
        return this.status(server, transactionId, false);
    }

    public ListenableFuture<BatchSignatureTIDsRespType> status(Server server, long transactionId, boolean justWaitForDocInfos) {
        if (Futures.containsKey(server, transactionId)) {
            return Futures.get(server, transactionId);
        }
        SettableFuture future = SettableFuture.create();
        Futures.put(server, transactionId, future);
        Checker checker = new Checker(server, transactionId, justWaitForDocInfos);
        this.schedule(checker);
        return future;
    }

    private BatchPollingService() {
    }

    private class Checker
    extends BasePollingService.BaseChecker {
        private boolean justWaitForDocInfos;

        public Checker(Server server, long transactionId, boolean justWaitForDocInfos) {
            super(server, transactionId);
            this.justWaitForDocInfos = justWaitForDocInfos;
        }

        protected void check(SettableFuture<BatchSignatureTIDsRespType> future) {
            try {
                BatchSignatureTIDsRespType signatureStatusResp = RequestStatusHelper.requestBatchStatus(this.server, this.transactionId);
                log.info("[TRANSACTION ID " + this.transactionId + "] Checking batch transaction ...");
                if (this.justWaitForDocInfos) {
                    if (signatureStatusResp.getDocumentSignatureStatus() != null) {
                        future.set((Object)signatureStatusResp);
                    } else {
                        BatchPollingService.this.schedule(this, this.counter);
                        log.info("[TRANSACTION ID " + this.transactionId + "] In progess yet. A next check was scheduled.");
                    }
                } else if (signatureStatusResp.getStatus().getStatusCode() == Status.TRANSACTION_IN_PROGRESS.getCode()) {
                    BatchPollingService.this.schedule(this, this.counter);
                    log.info("[TRANSACTION ID " + this.transactionId + "] In progess yet. A next check was scheduled.");
                } else {
                    future.set((Object)signatureStatusResp);
                }
            }
            catch (ICPMException e) {
                future.setException((Throwable)e);
            }
        }
    }
}

