/*
 * Decompiled with CFR 0.152.
 */
package br.com.esec.icpm.libs.signature.response.notify;

import br.com.esec.icpm.libs.Server;
import br.com.esec.icpm.libs.signature.response.Futures;
import br.com.esec.icpm.mss.ws.notification.BatchSignatureNotificationType;
import br.com.esec.icpm.mss.ws.notification.SignatureNotificationType;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotifyService {
    private static Logger log = LoggerFactory.getLogger(NotifyService.class);
    private static NotifyService instance;

    public static NotifyService getInstance() {
        if (instance == null) {
            instance = new NotifyService();
        }
        return instance;
    }

    public ListenableFuture<SignatureNotificationType> simple(Server server, long transactionId) {
        SettableFuture future = SettableFuture.create();
        Futures.put(server, transactionId, future);
        log.info("Waiting simple signature notification of transaction " + transactionId + "...");
        return future;
    }

    public ListenableFuture<BatchSignatureNotificationType> batch(Server server, long transactionId) {
        SettableFuture future = SettableFuture.create();
        Futures.put(server, transactionId, future);
        log.info("Waiting batch signature notification of transaction " + transactionId + "...");
        return future;
    }
}

