/*
 * Decompiled with CFR 0.152.
 */
package br.com.esec.icpm.libs.signature.response.handler.simple;

import br.com.esec.icpm.libs.Server;
import br.com.esec.icpm.libs.signature.response.ThreadPool;
import br.com.esec.icpm.libs.signature.response.handler.SignatureAsynchHandler;
import br.com.esec.icpm.libs.signature.response.handler.simple.BaseSimpleSignatureHandler;
import br.com.esec.icpm.libs.signature.response.notify.NotifyService;
import br.com.esec.icpm.mss.ws.SignatureRespType;
import br.com.esec.icpm.mss.ws.notification.SignatureNotificationType;
import br.com.esec.icpm.server.ws.ICPMException;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureSimpleAsynchWithNotifyHandler
extends BaseSimpleSignatureHandler
implements SignatureAsynchHandler {
    private static Logger log = LoggerFactory.getLogger(SignatureSimpleAsynchWithNotifyHandler.class);

    public SignatureSimpleAsynchWithNotifyHandler(Server server, long transactionId) {
        super(server, transactionId);
    }

    public SignatureSimpleAsynchWithNotifyHandler(Server server, SignatureRespType response) {
        super(server, response);
    }

    @Override
    public SignatureSimpleAsynchWithNotifyHandler waitTo() throws ICPMException, InterruptedException, TimeoutException {
        return this.waitTo(60L);
    }

    @Override
    public SignatureSimpleAsynchWithNotifyHandler waitTo(long timeout) throws ICPMException, InterruptedException, TimeoutException {
        ListenableFuture<SignatureNotificationType> result = NotifyService.getInstance().simple(this.server, this.transactionId);
        try {
            SignatureNotificationType signatureNotification = (SignatureNotificationType)result.get(timeout, TimeUnit.SECONDS);
            log.info("Simple signature arrived.");
            this.parseNotification(signatureNotification);
        }
        catch (TimeoutException e) {
            result.cancel(true);
            throw e;
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return this;
    }

    @Override
    public SignatureAsynchHandler addListener(final SignatureAsynchHandler.Listener listener) throws ICPMException, InterruptedException, TimeoutException {
        ListenableFuture<SignatureNotificationType> result = NotifyService.getInstance().simple(this.server, this.transactionId);
        Futures.addCallback(result, (FutureCallback)new FutureCallback<SignatureNotificationType>(){

            public void onSuccess(SignatureNotificationType signatureNotification) {
                try {
                    log.info("Batch signature arrived.");
                    SignatureSimpleAsynchWithNotifyHandler.this.parseNotification(signatureNotification);
                    listener.onSuccess(SignatureSimpleAsynchWithNotifyHandler.this);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }

            public void onFailure(Throwable t) {
                listener.onFailed(t);
            }
        }, (Executor)ThreadPool.instance);
        return this;
    }

    private void parseNotification(SignatureNotificationType signatureNotification) throws IOException {
        if (signatureNotification.getStatus() != null) {
            this.statusCode = signatureNotification.getStatus().getStatusCode();
            this.statusMessage = signatureNotification.getStatus().getStatusMessage();
            this.signature = this.parseSignature(this.statusCode, signatureNotification.getSignature());
        }
    }
}

