/*
 * Decompiled with CFR 0.152.
 */
package br.com.esec.icpm.libs.signature.response.handler.simple;

import br.com.esec.icpm.libs.Server;
import br.com.esec.icpm.libs.signature.exceptions.SignatureException;
import br.com.esec.icpm.libs.signature.response.handler.BaseSignatureHandler;
import br.com.esec.icpm.libs.signature.response.handler.SignatureHandler;
import br.com.esec.icpm.mss.ws.SignatureRespType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class BaseSimpleSignatureHandler
extends BaseSignatureHandler {
    protected InputStream signature;
    protected int statusCode;
    protected String statusMessage;

    public BaseSimpleSignatureHandler(Server server, SignatureRespType response) {
        super(server, response.getTransactionId());
        try {
            if (response.getStatus() != null) {
                this.statusCode = response.getStatus().getStatusCode();
                this.statusMessage = response.getStatus().getStatusMessage();
                this.signature = this.parseSignature(this.statusCode, response.getSignature());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public BaseSimpleSignatureHandler(Server server, long transactionId) {
        super(server, transactionId);
    }

    @Override
    public SignatureHandler save(OutputStream out) throws IOException, SignatureException {
        this.success();
        this.saveCades(out, this.signature);
        return this;
    }

    @Override
    public SignatureHandler saveAttached(OutputStream out0) throws IOException, SignatureException {
        return null;
    }

    @Override
    public SignatureHandler saveAttached(InputStream in, OutputStream out) throws IOException, SignatureException {
        this.success();
        this.saveCades(in, out, this.signature);
        return this;
    }

    @Override
    public SignatureHandler success() throws SignatureException {
        this.validateStatus(this.transactionId, this.statusCode, this.statusMessage);
        return this;
    }
}

