/*
 * Decompiled with CFR 0.152.
 */
package br.com.esec.icpm.libs.signature.response.handler.batch;

import br.com.esec.icpm.libs.Server;
import br.com.esec.icpm.libs.signature.response.handler.SignatureAsynchHandler;
import br.com.esec.icpm.libs.signature.response.handler.batch.BaseBatchSignatureHandler;
import br.com.esec.icpm.libs.signature.response.polling.BatchPollingService;
import br.com.esec.icpm.mss.ws.BatchSignatureTIDsRespType;
import br.com.esec.icpm.mss.ws.SignatureStandardType;
import br.com.esec.icpm.server.ws.ICPMException;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class BaseBatchAsynchSignatureHandler
extends BaseBatchSignatureHandler
implements SignatureAsynchHandler {
    public BaseBatchAsynchSignatureHandler(Server server, SignatureStandardType standard, long transactionId) {
        super(server, standard, transactionId);
    }

    public BaseBatchSignatureHandler.SignatureInfos waitForDocInfos() throws ICPMException, InterruptedException, TimeoutException {
        return this.waitForDocInfos(60L);
    }

    public BaseBatchSignatureHandler.SignatureInfos waitForDocInfos(long timeout) throws ICPMException, InterruptedException, TimeoutException {
        ListenableFuture<BatchSignatureTIDsRespType> result = BatchPollingService.getInstance().status(this.server, this.transactionId, true);
        try {
            BatchSignatureTIDsRespType signatureStatusResp = (BatchSignatureTIDsRespType)result.get(timeout, TimeUnit.SECONDS);
            this.update(signatureStatusResp);
        }
        catch (TimeoutException e) {
            result.cancel(true);
            throw e;
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
        return this.getDocInfos();
    }
}

