/*
 * Decompiled with CFR 0.152.
 */
package br.com.esec.icpm.libs.signature;

import br.com.esec.icpm.libs.signature.SignatureRequest;
import br.com.esec.icpm.libs.signature.helper.RequestSimpleSignatureHelper;
import br.com.esec.icpm.libs.signature.response.handler.simple.BaseSimpleSignatureHandler;
import br.com.esec.icpm.libs.signature.response.handler.simple.SignatureSimpleAsynchHandler;
import br.com.esec.icpm.libs.signature.response.handler.simple.SignatureSimpleAsynchWithNotifyHandler;
import br.com.esec.icpm.libs.signature.response.handler.simple.SignatureSimpleSynchHandler;
import br.com.esec.icpm.mss.ws.SignatureRespType;
import br.com.esec.icpm.server.ws.ICPMException;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSignatureRequest {
    private static Logger log = LoggerFactory.getLogger(SimpleSignatureRequest.class);
    private SignatureRequest request;
    private String message;

    public SimpleSignatureRequest(SignatureRequest request) {
        this.request = request;
    }

    public SimpleSignatureRequest message(String message) {
        this.message = message;
        return this;
    }

    public BaseSimpleSignatureHandler sign() throws ICPMException, IOException {
        log.info("Requesting asynch batch signature to '" + this.request.identifier + "'.");
        SignatureRespType response = RequestSimpleSignatureHelper.requestSynchSimpleSignature(this.request.server, this.request.identifier, this.message, this.request.policyType, this.request.testMode, this.request.options.certificateFilters, this.request.apId);
        return new SignatureSimpleSynchHandler(this.request.server, response);
    }

    public SignatureSimpleAsynchHandler asynchSign() throws ICPMException, IOException {
        log.info("Requesting asynch batch signature to '" + this.request.identifier + "'.");
        SignatureRespType response = RequestSimpleSignatureHelper.requestAsynchSimpleSignature(this.request.server, this.request.identifier, this.message, this.request.policyType, this.request.testMode, this.request.options.certificateFilters, this.request.apId);
        return new SignatureSimpleAsynchHandler(this.request.server, response);
    }

    public SignatureSimpleAsynchWithNotifyHandler asynchSignWithNotify() throws ICPMException, IOException {
        log.info("Requesting asynch batch signature to '" + this.request.identifier + "'.");
        SignatureRespType response = RequestSimpleSignatureHelper.requestAsynchWithNotifySimpleSignature(this.request.server, this.request.identifier, this.message, this.request.policyType, this.request.testMode, this.request.options.certificateFilters, this.request.apId);
        return new SignatureSimpleAsynchWithNotifyHandler(this.request.server, response);
    }

    public SignatureSimpleAsynchHandler waitFor(long transactionId) throws ICPMException, InterruptedException, TimeoutException {
        return new SignatureSimpleAsynchHandler(this.request.server, transactionId).waitTo();
    }
}

