/*
 * Decompiled with CFR 0.152.
 */
package br.com.esec.icpm.libs.signature;

import br.com.esec.icpm.libs.Server;
import br.com.esec.icpm.libs.signature.BatchSignatureRequest;
import br.com.esec.icpm.libs.signature.SignatureOptions;
import br.com.esec.icpm.libs.signature.SimpleSignatureRequest;
import br.com.esec.icpm.server.ws.SignaturePolicyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureRequest {
    private static Logger log = LoggerFactory.getLogger(SignatureRequest.class);
    String identifier;
    boolean testMode;
    SignaturePolicyType policyType = SignaturePolicyType.AD_RB;
    Server server;
    Long apId = 0L;
    SignatureOptions options = new SignatureOptions();

    public SignatureRequest(Server server) {
        this.server = server;
    }

    public SignatureRequest testMode() {
        this.testMode = true;
        return this;
    }

    public SignatureRequest apId(Long apId) {
        this.apId = apId;
        return this;
    }

    public SignatureRequest toUser(String identifier) {
        this.identifier = identifier;
        return this;
    }

    public SimpleSignatureRequest simple() {
        return new SimpleSignatureRequest(this);
    }

    public BatchSignatureRequest batch() {
        return new BatchSignatureRequest(this);
    }

    public SignatureRequest adRb() {
        this.policyType = SignaturePolicyType.AD_RB;
        return this;
    }

    public SignatureRequest adRt() {
        this.policyType = SignaturePolicyType.AD_RT;
        return this;
    }

    public SignatureRequest adRc() {
        this.policyType = SignaturePolicyType.AD_RC;
        return this;
    }

    public SignatureRequest adRv() {
        this.policyType = SignaturePolicyType.AD_RV;
        return this;
    }

    public SignatureRequest adRa() {
        this.policyType = SignaturePolicyType.AD_RA;
        return this;
    }

    public SignatureRequest useProductionServer() {
        this.server = Server.PRODUCTION;
        return this;
    }

    public SignatureRequest useTestServer() {
        this.server = Server.TEST;
        return this;
    }

    public SignatureRequest useArbitraryServer(String host, boolean secure) {
        this.server = new Server(host, secure);
        return this;
    }

    public SignatureOptions options() {
        return this.options;
    }
}

