/*
 * Decompiled with CFR 0.152.
 */
package br.com.esec.icpm.libs.signature;

import br.com.esec.icpm.libs.Server;
import br.com.esec.icpm.libs.signature.ApplicationProviderClient;
import br.com.esec.icpm.mss.rest.ApplicationProviderResource;
import br.com.esec.icpm.mss.ws.SignaturePortType;
import br.com.esec.icpm.signer.ws.rest.SslUtils;
import br.com.esec.icpm.signer.ws.soap.CxfUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import org.apache.commons.io.IOUtils;

public class ApWsFactory {
    private static ApWsFactory instance;
    private Map<Server, ClientBuilder> builders = new HashMap<Server, ClientBuilder>();

    public static ApWsFactory getInstance() {
        if (instance == null) {
            instance = new ApWsFactory();
        }
        return instance;
    }

    private ApWsFactory() {
    }

    public SignaturePortType getSoapService(Server server) {
        try {
            URL signatureRequestSoapWsUrl = this.getWsdlUrl(server);
            Service signatureService = Service.create((URL)signatureRequestSoapWsUrl, (QName)SignaturePortType.QNAME);
            SignaturePortType port = (SignaturePortType)signatureService.getPort(SignaturePortType.class);
            if (server.isSecure()) {
                CxfUtils.config((Object)port);
            }
            return port;
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL getWsdlUrl(Server server) throws MalformedURLException, URISyntaxException {
        URL signatureRequestSoapWsUrl = new URL(server.getSoapWsUrl());
        ClientBuilder builder = this.getClientBuilder(server);
        Response response = null;
        try {
            Client client = builder.build();
            Invocation.Builder request = client.target(signatureRequestSoapWsUrl.toURI()).request();
            response = request.get();
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                throw new IllegalStateException("Error " + response.getStatus() + " when try download wsdl on url '" + signatureRequestSoapWsUrl + "'.");
            }
            InputStream wsdlDataIn = (InputStream)response.readEntity(InputStream.class);
            File tempFile = File.createTempFile("certillion", ".wsdl");
            FileOutputStream out = new FileOutputStream(tempFile);
            try {
                IOUtils.copy((InputStream)wsdlDataIn, (OutputStream)out);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)out);
                IOUtils.closeQuietly((InputStream)wsdlDataIn);
            }
            URL uRL = tempFile.toURI().toURL();
            return uRL;
        }
        catch (IOException e) {
            throw new IllegalStateException();
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    public ApplicationProviderResource getRestService(Server server) {
        ClientBuilder builder = this.getClientBuilder(server);
        Client client = builder.build();
        WebTarget target = client.target(server.getRestWsUrl());
        return new ApplicationProviderClient(target);
    }

    private ClientBuilder getClientBuilder(Server server) {
        if (!this.builders.containsKey(server)) {
            ClientBuilder builder = ClientBuilder.newBuilder();
            if (server.isSecure()) {
                SslUtils.config((ClientBuilder)builder);
            }
            this.builders.put(server, builder);
        }
        return this.builders.get(server);
    }
}

