package br.com.esec.icpm.libs.signature.response.handler;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import br.com.esec.icpm.libs.signature.exceptions.SignatureException;

public interface SignatureHandler {

	/**
	 * Save the signature.
	 * 
	 * @param out
	 *            stream to save
	 * @return
	 * @throws IOException
	 * @throws SignatureException
	 */
	SignatureHandler save(OutputStream out) throws IOException, SignatureException;
	
	/**
	 * Save a document with signature attached. This method will download the wntire document with signature attached from Certillion Server.
	 * 
	 * @param out
	 *            stream to save
	 * @return
	 * @throws IOException
	 * @throws SignatureException
	 */
	SignatureHandler saveAttached(OutputStream out) throws IOException, SignatureException;

	/**
	 * Save a document with signature attached. This method will attach the signature in the document on the client side. 
	 * 
	 * @param in
	 *            stream to read original document
	 * @param out
	 *            stream to save
	 * @return
	 * @throws IOException
	 * @throws SignatureException
	 */
	SignatureHandler saveAttached(InputStream in, OutputStream out) throws IOException, SignatureException;

	/**
	 * Ensure the signature happen with sucess
	 * 
	 * @return
	 * @throws SignatureException
	 */
	SignatureHandler success() throws SignatureException;

	/**
	 * Get the transaction id of the transaction.
	 * 
	 * @return transation id
	 */
	long transactionId();


}
