package br.com.esec.icpm.libs.signature.response.download;

import java.io.IOException;
import java.io.OutputStream;

import br.com.esec.icpm.libs.Server;
import br.com.esec.icpm.libs.signature.helper.DownloadSignatureHelper;
import br.com.esec.icpm.libs.signature.helper.RequestStatusHelper;
import br.com.esec.icpm.mss.ws.SignatureStatusRespType;
import br.com.esec.icpm.server.factory.Status;
import br.com.esec.icpm.server.ws.ICPMException;

public class SignatureDownloader {
	
	private Server server;

	public SignatureDownloader(Server server) {
		this.server = server;
	}

	/**
	 * Download the document and write on the output stream.
	 * 
	 * <p> DONT CLOSE THE OUTPUT STREAM.
	 * 
	 * @param transactionId
	 * @param out
	 * @throws IOException
	 * @throws ICPMException
	 */
	public void attached(Long transactionId, OutputStream out) throws IOException, ICPMException {
		SignatureStatusRespType signatureStatusResp = RequestStatusHelper.requestStatus(server, transactionId);

		if (signatureStatusResp.getStatus().getStatusCode() == Status.SIGNATURE_VALID.getCode()) {
			DownloadSignatureHelper.downloadAttachedDocument(server, transactionId, out);
		} else {
			throw new IllegalStateException("The status " + signatureStatusResp.getStatus().getStatusCode() + " is unrecognizable in this case.");
		}
		
	}

}
