package br.com.esec.icpm.libs.signature.response;

import java.util.HashMap;
import java.util.Map;

import com.google.common.util.concurrent.ListenableFuture;

import br.com.esec.icpm.libs.Server;

@SuppressWarnings("unchecked")
public final class Futures<V> {

	private static Map<ServerAndTransactionKey, ListenableFuture<?>> values = new HashMap<ServerAndTransactionKey, ListenableFuture<?>>();

	public static void put(Server server, Long transactionId, ListenableFuture<?> value) {
		values.put(new ServerAndTransactionKey(server, transactionId), value);
	}

	public static <V> ListenableFuture<V> get(Server server, Long transactionId) {
		return (ListenableFuture<V>) values.get(new ServerAndTransactionKey(server, transactionId));
	}

	public static <V> ListenableFuture<V> remove(Server server, long transactionId) {
		return (ListenableFuture<V>) values.remove(new ServerAndTransactionKey(server, transactionId));
	}

	public static boolean containsKey(Server server, long transactionId) {
		return values.containsKey(new ServerAndTransactionKey(server, transactionId));
	}

	static class ServerAndTransactionKey {
		Server server;
		Long transactionId;

		public ServerAndTransactionKey(Server server, Long transactionId) {
			this.server = server;
			this.transactionId = transactionId;
		}

		@Override
		public String toString() {
			return "ServerAndTransactionKey [server=" + server + ", transactionId=" + transactionId + "]";
		}

		@Override
		public int hashCode() {
			final int prime = 31;
			int result = 1;
			result = prime * result + ((server == null) ? 0 : server.hashCode());
			result = prime * result + ((transactionId == null) ? 0 : transactionId.hashCode());
			return result;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			ServerAndTransactionKey other = (ServerAndTransactionKey) obj;
			if (server == null) {
				if (other.server != null)
					return false;
			} else if (!server.equals(other.server))
				return false;
			if (transactionId == null) {
				if (other.transactionId != null)
					return false;
			} else if (!transactionId.equals(other.transactionId))
				return false;
			return true;
		}

	}

}
