package br.com.esec.icpm.libs;

import java.security.Security;

import org.bouncycastle.jce.provider.BouncyCastleProvider;

import br.com.esec.icpm.libs.signature.SignatureRequest;
import br.com.esec.icpm.libs.signature.response.download.SignatureDownloader;
import br.com.esec.icpm.libs.signature.response.notify.SignatureNotifier;

public class Certillion {

	static Server server = Server.PRODUCTION;
	
	static {
		if (Security.getProvider(BouncyCastleProvider.PROVIDER_NAME) == null) {
			Security.addProvider(new BouncyCastleProvider());
		}
	}
	
	public static Configurable config() {
		return new Configurable();
	}
	
	public static SignatureRequest signature() {
		return new SignatureRequest(server);
	}
	
	public static SignatureNotifier notifySignature() {
		return new SignatureNotifier(server);
	}

	public static SignatureDownloader downloadSignature() {
		return new SignatureDownloader(server);
	}
	
}
