/*
 * Decompiled with CFR 0.152.
 */
package br.com.esec.icpm.libs.signature.response.polling;

import br.com.esec.icpm.libs.Server;
import br.com.esec.icpm.libs.signature.helper.RequestBatchSignatureHelper;
import br.com.esec.icpm.libs.signature.helper.RequestStatusHelper;
import br.com.esec.icpm.libs.signature.response.Futures;
import br.com.esec.icpm.libs.signature.response.polling.BasePollingService;
import br.com.esec.icpm.mss.ws.SignatureStatusRespType;
import br.com.esec.icpm.server.factory.Status;
import br.com.esec.icpm.server.ws.ICPMException;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimplePollingService
extends BasePollingService<SignatureStatusRespType> {
    private static Logger log = LoggerFactory.getLogger(RequestBatchSignatureHelper.class);
    private static SimplePollingService instance;

    public static SimplePollingService getInstance() {
        if (instance == null) {
            instance = new SimplePollingService();
        }
        return instance;
    }

    public ListenableFuture<SignatureStatusRespType> status(Server server, long transactionId) {
        if (Futures.containsKey(server, transactionId)) {
            return Futures.get(server, transactionId);
        }
        SettableFuture future = SettableFuture.create();
        Futures.put(server, transactionId, future);
        Checker checker = new Checker(server, transactionId);
        this.schedule(checker);
        return future;
    }

    private SimplePollingService() {
    }

    private class Checker
    extends BasePollingService.BaseChecker {
        public Checker(Server server, long transactionId) {
            super(server, transactionId);
        }

        protected void check(SettableFuture<SignatureStatusRespType> future) {
            try {
                SignatureStatusRespType signatureStatusResp = RequestStatusHelper.requestStatus(this.server, this.transactionId);
                log.info("[TRANSACTION ID " + this.transactionId + "] Checking simple transaction ...");
                if (signatureStatusResp.getStatus().getStatusCode() == Status.TRANSACTION_IN_PROGRESS.getCode()) {
                    SimplePollingService.this.schedule(this, this.counter);
                    log.info("[TRANSACTION ID " + this.transactionId + "] In progess yet. A next check was scheduled.");
                } else {
                    future.set((Object)signatureStatusResp);
                }
            }
            catch (ICPMException e) {
                future.setException((Throwable)e);
            }
        }
    }
}

