/*
 * Decompiled with CFR 0.152.
 */
package br.com.esec.icpm.libs.signature.response.polling;

import br.com.esec.icpm.libs.Server;
import br.com.esec.icpm.libs.signature.response.Futures;
import br.com.esec.icpm.libs.signature.response.ThreadPool;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.TimeUnit;

public abstract class BasePollingService<T> {
    protected final int WAIT_TIME = 2000;
    protected final int MULTIPLIER_FACTOR_WAIT_TIME = 2;

    protected void schedule(BaseChecker checker) {
        this.schedule(checker, 0);
    }

    protected void schedule(BaseChecker checker, int tries) {
        int waitTime = 2000 + 2000 * (2 * (tries / 25));
        ThreadPool.instance.schedule(checker, (long)waitTime, TimeUnit.MILLISECONDS);
    }

    protected abstract class BaseChecker
    implements Runnable {
        protected static final int MAX_EXECUTIONS = 1000;
        protected Server server;
        protected long transactionId;
        protected int counter = 0;

        public BaseChecker(Server server, long transactionId) {
            this.server = server;
            this.transactionId = transactionId;
        }

        @Override
        public void run() {
            SettableFuture future = (SettableFuture)Futures.get(this.server, this.transactionId);
            if (future == null || future.isDone() || future.isCancelled()) {
                Futures.remove(this.server, this.transactionId);
                return;
            }
            if (this.counter == 1000) {
                Futures.remove(this.server, this.transactionId);
                return;
            }
            this.check(future);
            ++this.counter;
        }

        protected abstract void check(SettableFuture<T> var1);
    }
}

