/*
 * Decompiled with CFR 0.152.
 */
package br.com.esec.icpm.libs.signature.response.handler.simple;

import br.com.esec.icpm.libs.Server;
import br.com.esec.icpm.libs.signature.response.ThreadPool;
import br.com.esec.icpm.libs.signature.response.handler.SignatureAsynchHandler;
import br.com.esec.icpm.libs.signature.response.handler.simple.BaseSimpleSignatureHandler;
import br.com.esec.icpm.libs.signature.response.polling.SimplePollingService;
import br.com.esec.icpm.mss.ws.SignatureRespType;
import br.com.esec.icpm.mss.ws.SignatureStatusRespType;
import br.com.esec.icpm.server.ws.ICPMException;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureSimpleAsynchHandler
extends BaseSimpleSignatureHandler
implements SignatureAsynchHandler {
    private static Logger log = LoggerFactory.getLogger(SignatureSimpleAsynchHandler.class);

    public SignatureSimpleAsynchHandler(Server server, long transactionId) {
        super(server, transactionId);
    }

    public SignatureSimpleAsynchHandler(Server server, SignatureRespType response) {
        super(server, response);
    }

    @Override
    public SignatureSimpleAsynchHandler waitTo() throws ICPMException, InterruptedException, TimeoutException {
        return this.waitTo(60L);
    }

    @Override
    public SignatureSimpleAsynchHandler waitTo(long timeout) throws ICPMException, InterruptedException, TimeoutException {
        ListenableFuture<SignatureStatusRespType> result = SimplePollingService.getInstance().status(this.server, this.transactionId);
        try {
            SignatureStatusRespType signatureStatusResp = (SignatureStatusRespType)result.get(timeout, TimeUnit.SECONDS);
            log.info("Simple signature arrived.");
            this.parseStatus(signatureStatusResp);
        }
        catch (TimeoutException e) {
            result.cancel(true);
            throw e;
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return this;
    }

    @Override
    public SignatureAsynchHandler addListener(final SignatureAsynchHandler.Listener listener) throws ICPMException, InterruptedException, TimeoutException {
        ListenableFuture<SignatureStatusRespType> result = SimplePollingService.getInstance().status(this.server, this.transactionId);
        Futures.addCallback(result, (FutureCallback)new FutureCallback<SignatureStatusRespType>(){

            public void onSuccess(SignatureStatusRespType signatureStatus) {
                try {
                    log.info("Simple signature arrived.");
                    SignatureSimpleAsynchHandler.this.parseStatus(signatureStatus);
                    listener.onSuccess(SignatureSimpleAsynchHandler.this);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }

            public void onFailure(Throwable t) {
                listener.onFailed(t);
            }
        }, (Executor)ThreadPool.instance);
        return this;
    }

    private void parseStatus(SignatureStatusRespType signatureStatusResp) throws IOException {
        if (signatureStatusResp.getStatus() != null) {
            this.statusCode = signatureStatusResp.getStatus().getStatusCode();
            this.statusMessage = signatureStatusResp.getStatus().getStatusMessage();
            this.signature = this.parseSignature(this.statusCode, signatureStatusResp.getSignature());
        }
    }
}

