/*
 * Decompiled with CFR 0.152.
 */
package br.com.esec.icpm.libs.signature.response.handler.batch;

import br.com.esec.icpm.libs.Server;
import br.com.esec.icpm.libs.signature.response.handler.batch.BaseBatchSignatureHandler;
import br.com.esec.icpm.mss.ws.BatchSignatureComplexDocumentRespType;
import br.com.esec.icpm.mss.ws.DocumentSignatureInfoType;
import br.com.esec.icpm.mss.ws.SignatureStandardType;
import br.com.esec.icpm.server.factory.Status;
import java.io.IOException;
import java.io.InputStream;
import java.util.Deque;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureBatchSynchHandler
extends BaseBatchSignatureHandler {
    private static Logger log = LoggerFactory.getLogger(SignatureBatchSynchHandler.class);

    public SignatureBatchSynchHandler(Server server, SignatureStandardType standard, BatchSignatureComplexDocumentRespType response) throws IOException {
        super(server, standard, response.getTransactionId());
        if (response.getStatus() != null) {
            this.statusCode = response.getStatus().getStatusCode();
            this.statusMessage = response.getStatus().getStatusMessage();
            if (this.statusCode != Status.REQUEST_OK.getCode()) {
                throw new IllegalStateException("Something bad happened. The signature response return eith status " + this.statusMessage + " (" + this.statusCode + ").");
            }
        }
        Deque<BaseBatchSignatureHandler.DocumentStatus> documentsStatus = this.getDocumentsStatus();
        List signatures = response.getSignatures();
        if (signatures != null) {
            for (DocumentSignatureInfoType docInfo : signatures) {
                int statusCode = docInfo.getStatus().getStatusCode();
                String statusMessage = docInfo.getStatus().getStatusMessage();
                String name = docInfo.getDocumentName();
                InputStream signature = null;
                try {
                    signature = this.parseSignature(statusCode, docInfo.getSignature());
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
                documentsStatus.add(new BaseBatchSignatureHandler.DocumentStatus(-1L, name, statusCode, statusMessage, signature));
            }
        }
    }
}

