/*
 * Decompiled with CFR 0.152.
 */
package br.com.esec.icpm.libs.signature.response.handler.batch;

import br.com.esec.icpm.libs.Server;
import br.com.esec.icpm.libs.signature.response.ThreadPool;
import br.com.esec.icpm.libs.signature.response.handler.SignatureAsynchHandler;
import br.com.esec.icpm.libs.signature.response.handler.batch.BaseBatchAsynchSignatureHandler;
import br.com.esec.icpm.libs.signature.response.notify.NotifyService;
import br.com.esec.icpm.mss.ws.BatchSignatureComplexDocumentRespType;
import br.com.esec.icpm.mss.ws.SignatureStandardType;
import br.com.esec.icpm.mss.ws.notification.BatchSignatureNotificationType;
import br.com.esec.icpm.server.factory.Status;
import br.com.esec.icpm.server.ws.ICPMException;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureBatchAsynchWithNotifyHandler
extends BaseBatchAsynchSignatureHandler
implements SignatureAsynchHandler {
    private static Logger log = LoggerFactory.getLogger(SignatureBatchAsynchWithNotifyHandler.class);

    public SignatureBatchAsynchWithNotifyHandler(Server server, SignatureStandardType standard, BatchSignatureComplexDocumentRespType response) throws IOException {
        super(server, standard, response.getTransactionId());
        if (response.getStatus() != null) {
            int statusCode = response.getStatus().getStatusCode();
            String statusMessage = response.getStatus().getStatusMessage();
            if (statusCode != Status.REQUEST_OK.getCode()) {
                throw new IllegalStateException("Something bad happened. The signature response return eith status " + statusMessage + " (" + statusCode + ").");
            }
        }
    }

    public SignatureBatchAsynchWithNotifyHandler(Server server, SignatureStandardType standard, long transactionId) {
        super(server, standard, transactionId);
    }

    @Override
    public SignatureBatchAsynchWithNotifyHandler waitTo() throws ICPMException, InterruptedException, TimeoutException {
        return this.waitTo(60L);
    }

    @Override
    public SignatureBatchAsynchWithNotifyHandler waitTo(long timeout) throws ICPMException, InterruptedException, TimeoutException {
        ListenableFuture<BatchSignatureNotificationType> result = NotifyService.getInstance().batch(this.server, this.transactionId);
        try {
            BatchSignatureNotificationType signatureNotification = (BatchSignatureNotificationType)result.get(timeout, TimeUnit.SECONDS);
            log.info("Batch signature arrived.");
            this.update(signatureNotification);
        }
        catch (TimeoutException e) {
            result.cancel(true);
            throw e;
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
        return this;
    }

    @Override
    public SignatureAsynchHandler addListener(final SignatureAsynchHandler.Listener listener) throws ICPMException, InterruptedException, TimeoutException {
        ListenableFuture<BatchSignatureNotificationType> result = NotifyService.getInstance().batch(this.server, this.transactionId);
        Futures.addCallback(result, (FutureCallback)new FutureCallback<BatchSignatureNotificationType>(){

            public void onSuccess(BatchSignatureNotificationType signatureNotification) {
                try {
                    log.info("Batch signature arrived.");
                    SignatureBatchAsynchWithNotifyHandler.this.update(signatureNotification);
                    listener.onSuccess(SignatureBatchAsynchWithNotifyHandler.this);
                }
                catch (ICPMException e) {
                    throw new IllegalStateException(e);
                }
            }

            public void onFailure(Throwable t) {
                listener.onFailed(t);
            }
        }, (Executor)ThreadPool.instance);
        return this;
    }
}

