/*
 * Decompiled with CFR 0.152.
 */
package br.com.esec.icpm.libs.signature.response.handler.batch;

import br.com.esec.icpm.libs.Server;
import br.com.esec.icpm.libs.signature.exceptions.SignatureException;
import br.com.esec.icpm.libs.signature.helper.DownloadSignatureHelper;
import br.com.esec.icpm.libs.signature.helper.RequestStatusHelper;
import br.com.esec.icpm.libs.signature.response.handler.BaseSignatureHandler;
import br.com.esec.icpm.libs.signature.response.handler.SignatureHandler;
import br.com.esec.icpm.libs.signature.response.handler.batch.BatchSignatureHandler;
import br.com.esec.icpm.mss.ws.BatchSignatureTIDsRespType;
import br.com.esec.icpm.mss.ws.DocumentSignatureStatusInfoType;
import br.com.esec.icpm.mss.ws.SignatureStandardType;
import br.com.esec.icpm.mss.ws.SignatureStatusRespType;
import br.com.esec.icpm.mss.ws.notification.BatchSignatureNotificationType;
import br.com.esec.icpm.server.factory.Status;
import br.com.esec.icpm.server.ws.ICPMException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseBatchSignatureHandler
extends BaseSignatureHandler
implements BatchSignatureHandler {
    private static Logger log = LoggerFactory.getLogger(BaseBatchSignatureHandler.class);
    protected int statusCode;
    protected String statusMessage;
    protected SignatureStandardType standard;
    private Deque<DocumentStatus> documentsStatus = new LinkedList<DocumentStatus>();

    public BaseBatchSignatureHandler(Server server, SignatureStandardType standard, long transactionId) {
        super(server, transactionId);
        this.standard = standard;
    }

    protected void update(BatchSignatureTIDsRespType signatureStatusResp) throws ICPMException {
        this.statusCode = signatureStatusResp.getStatus().getStatusCode();
        this.statusMessage = signatureStatusResp.getStatus().getStatusMessage();
        this.documentsStatus = this.parseDocumentStatus(signatureStatusResp.getDocumentSignatureStatus());
    }

    protected void update(BatchSignatureNotificationType signatureStatusResp) throws ICPMException {
        this.statusCode = signatureStatusResp.getStatus().getStatusCode();
        this.statusMessage = signatureStatusResp.getStatus().getStatusMessage();
        this.documentsStatus = this.parseDocumentStatus(signatureStatusResp.getSignatures());
    }

    @Override
    public SignatureHandler save(OutputStream out) throws IOException, SignatureException {
        block6: {
            DocumentStatus docStatus;
            block5: {
                this.success();
                docStatus = this.documentsStatus.removeFirst();
                log.info("Saving document signature of document '" + docStatus.getName() + "'.");
                this.validateStatus(this.transactionId, docStatus.getStatusCode(), docStatus.getStatusMesssage());
                if (docStatus.getStatusCode() != Status.SIGNATURE_VALID.getCode()) break block5;
                switch (this.standard) {
                    case CADES: {
                        this.saveCades(out, docStatus.getSignature());
                        break block6;
                    }
                    case ADOBEPDF: {
                        throw new IllegalStateException("Error. To save with AdobePdf we need the stream to original document again.");
                    }
                    case XADES: {
                        throw new IllegalStateException("Error. To save with XAdES we need the stream to original document again.");
                    }
                    default: {
                        throw new IllegalStateException("Standard '" + this.standard + "' is unrecognizable.");
                    }
                }
            }
            throw new IllegalStateException("The status " + docStatus.getStatusCode() + " is unrecognizable in this case.");
        }
        return this;
    }

    @Override
    public SignatureHandler saveAttached(OutputStream out) throws IOException, SignatureException {
        this.success();
        DocumentStatus docStatus = this.documentsStatus.removeFirst();
        log.info("Saving attached signature of document '" + docStatus.getName() + "'.");
        this.validateStatus(this.transactionId, docStatus.getStatusCode(), docStatus.getStatusMesssage());
        if (docStatus.getStatusCode() != Status.SIGNATURE_VALID.getCode()) {
            throw new IllegalStateException("The status " + docStatus.getStatusCode() + " is unrecognizable in this case.");
        }
        DownloadSignatureHelper.downloadAttachedDocument(this.server, docStatus.docId, out);
        return this;
    }

    @Override
    public SignatureHandler saveAttached(InputStream in, OutputStream out) throws IOException, SignatureException {
        block6: {
            DocumentStatus docStatus;
            block5: {
                this.success();
                docStatus = this.documentsStatus.removeFirst();
                log.info("Saving attached signature of document '" + docStatus.getName() + "'.");
                this.validateStatus(this.transactionId, docStatus.getStatusCode(), docStatus.getStatusMesssage());
                if (docStatus.getStatusCode() != Status.SIGNATURE_VALID.getCode()) break block5;
                switch (this.standard) {
                    case CADES: {
                        this.saveCades(docStatus.getDocId(), in, out, docStatus.getSignature());
                        break block6;
                    }
                    case ADOBEPDF: {
                        this.saveAdobePdf(docStatus.getDocId(), in, out, docStatus.getSignature());
                        break block6;
                    }
                    case XADES: {
                        this.saveXades(docStatus.getDocId(), in, out, docStatus.getSignature());
                        break block6;
                    }
                    default: {
                        throw new IllegalStateException("Standard '" + this.standard + "' is unrecognizable.");
                    }
                }
            }
            throw new IllegalStateException("The status " + docStatus.getStatusCode() + " is unrecognizable in this case.");
        }
        return this;
    }

    @Override
    public SignatureHandler success() throws SignatureException {
        this.validateStatus(this.transactionId, this.statusCode, this.statusMessage);
        return this;
    }

    @Override
    public SignatureInfos getDocInfos() {
        return new SignatureInfos(this.transactionId, this.getDocumentsStatus());
    }

    protected Deque<DocumentStatus> parseDocumentStatus(List<DocumentSignatureStatusInfoType> signatures) throws ICPMException {
        LinkedList<DocumentStatus> documentsStatus = new LinkedList<DocumentStatus>();
        for (DocumentSignatureStatusInfoType docStatusInfo : signatures) {
            long docId = docStatusInfo.getTransactionId();
            int statusCode = docStatusInfo.getStatus().getStatusCode();
            String statusMesssage = docStatusInfo.getStatus().getStatusMessage();
            String name = docStatusInfo.getDocumentName();
            InputStream signature = null;
            try {
                if (statusCode == Status.SIGNATURE_VALID.getCode()) {
                    SignatureStatusRespType status = RequestStatusHelper.requestStatus(this.server, docId);
                    signature = this.parseSignature(statusCode, status.getSignature());
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            documentsStatus.add(new DocumentStatus(docId, name, statusCode, statusMesssage, signature));
        }
        return documentsStatus;
    }

    protected Deque<DocumentStatus> getDocumentsStatus() {
        return this.documentsStatus;
    }

    public class DocumentStatus {
        private final long docId;
        private final String name;
        private final int statusCode;
        private final String statusMesssage;
        private final InputStream signature;

        public DocumentStatus(long docId, String name, int statusCode, String statusMesssage, InputStream signature) {
            this.docId = docId;
            this.name = name;
            this.statusCode = statusCode;
            this.statusMesssage = statusMesssage;
            this.signature = signature;
        }

        public String getName() {
            return this.name;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public InputStream getSignature() {
            return this.signature;
        }

        public long getDocId() {
            return this.docId;
        }

        public String getStatusMesssage() {
            return this.statusMesssage;
        }
    }

    public class SignatureInfos {
        private final long transactionId;
        private final Deque<DocumentStatus> documentsStatus;

        public SignatureInfos(long transactionId, Deque<DocumentStatus> documentsStatus) {
            this.transactionId = transactionId;
            this.documentsStatus = documentsStatus;
        }

        public long getTransactionId() {
            return this.transactionId;
        }

        public Deque<DocumentStatus> getDocumentsStatus() {
            return this.documentsStatus;
        }
    }
}

