/*
 * Decompiled with CFR 0.152.
 */
package br.com.esec.icpm.libs.signature.helper.attach;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.BEROctetString;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.util.io.Streams;

public class CadesAttachSignatureHelper {
    public static void attach(long transactionId, InputStream originalDocument, InputStream signature, OutputStream signedDocument) {
        ASN1InputStream signatureAsn1In = null;
        try {
            signatureAsn1In = new ASN1InputStream(signature);
            ContentInfo contentInfo = ContentInfo.getInstance((Object)signatureAsn1In.readObject());
            SignedData sdDetached = SignedData.getInstance((Object)contentInfo.getContent());
            ContentInfo encapContentInfo = new ContentInfo(CMSObjectIdentifiers.data, (ASN1Encodable)new BEROctetString(IOUtils.toByteArray((InputStream)originalDocument)));
            SignedData sdAttached = new SignedData(sdDetached.getDigestAlgorithms(), encapContentInfo, sdDetached.getCertificates(), sdDetached.getCRLs(), sdDetached.getSignerInfos());
            ASN1OutputStream signedDocumentAsn1Out = new ASN1OutputStream(signedDocument);
            ContentInfo contentInfoAttached = new ContentInfo(PKCSObjectIdentifiers.signedData, (ASN1Encodable)sdAttached);
            signedDocumentAsn1Out.writeObject((ASN1Encodable)contentInfoAttached);
            signedDocumentAsn1Out.close();
        }
        catch (Exception e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(signatureAsn1In);
                IOUtils.closeQuietly((InputStream)originalDocument);
                IOUtils.closeQuietly((InputStream)signature);
                IOUtils.closeQuietly((OutputStream)signedDocument);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)signatureAsn1In);
        IOUtils.closeQuietly((InputStream)originalDocument);
        IOUtils.closeQuietly((InputStream)signature);
        IOUtils.closeQuietly((OutputStream)signedDocument);
    }

    static class CMSProcessableInputStream
    implements CMSProcessable {
        private InputStream input;
        private boolean used = false;

        public CMSProcessableInputStream(InputStream input) {
            this.input = input;
        }

        public InputStream getInputStream() {
            this.checkSingleUsage();
            return this.input;
        }

        public void write(OutputStream zOut) throws IOException, CMSException {
            this.checkSingleUsage();
            Streams.pipeAll((InputStream)this.input, (OutputStream)zOut);
            this.input.close();
        }

        public Object getContent() {
            return this.getInputStream();
        }

        private synchronized void checkSingleUsage() {
            if (this.used) {
                throw new IllegalStateException("CMSProcessableInputStream can only be used once");
            }
            this.used = true;
        }
    }
}

