/*
 * Decompiled with CFR 0.152.
 */
package br.com.esec.icpm.libs.signature.helper;

import br.com.esec.icpm.libs.Server;
import br.com.esec.icpm.libs.signature.ApWsFactory;
import br.com.esec.icpm.mss.ws.MessagingModeType;
import br.com.esec.icpm.mss.ws.SignaturePortType;
import br.com.esec.icpm.mss.ws.SignatureRespType;
import br.com.esec.icpm.mss.ws.SignatureSimpleDocumentReqType;
import br.com.esec.icpm.server.ws.CertificateFiltersType;
import br.com.esec.icpm.server.ws.ICPMException;
import br.com.esec.icpm.server.ws.MobileUserType;
import br.com.esec.icpm.server.ws.SignaturePolicyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestSimpleSignatureHelper {
    private static Logger log = LoggerFactory.getLogger(RequestSimpleSignatureHelper.class);

    public static SignatureRespType requestSynchSimpleSignature(Server server, String identifier, String message, SignaturePolicyType policyType, boolean testMode, CertificateFiltersType certificateFilters, Long apId) throws ICPMException {
        log.info("Requesting synch simple signature...");
        SignaturePortType signaturePort = ApWsFactory.getInstance().getSoapService(server);
        SignatureSimpleDocumentReqType request = RequestSimpleSignatureHelper.prepareSimpleRequest(identifier, message, policyType, testMode, certificateFilters, MessagingModeType.SYNCH, apId);
        SignatureRespType response = signaturePort.signatureSimpleDocument(request);
        log.info("Signature requested with transaction id " + response.getTransactionId() + ".");
        return response;
    }

    public static SignatureRespType requestAsynchSimpleSignature(Server server, String identifier, String message, SignaturePolicyType policyType, boolean testMode, CertificateFiltersType certificateFilters, Long apId) throws ICPMException {
        log.info("Requesting asynch simple signature...");
        SignaturePortType signaturePort = ApWsFactory.getInstance().getSoapService(server);
        SignatureSimpleDocumentReqType request = RequestSimpleSignatureHelper.prepareSimpleRequest(identifier, message, policyType, testMode, certificateFilters, MessagingModeType.ASYNCH_CLIENT_SERVER, apId);
        SignatureRespType response = signaturePort.signatureSimpleDocument(request);
        log.info("Signature requested with transaction id " + response.getTransactionId() + ".");
        return response;
    }

    public static SignatureRespType requestAsynchWithNotifySimpleSignature(Server server, String identifier, String message, SignaturePolicyType policyType, boolean testMode, CertificateFiltersType certificateFilters, Long apId) throws ICPMException {
        log.info("Requesting asynch simple signature...");
        SignaturePortType signaturePort = ApWsFactory.getInstance().getSoapService(server);
        SignatureSimpleDocumentReqType request = RequestSimpleSignatureHelper.prepareSimpleRequest(identifier, message, policyType, testMode, certificateFilters, MessagingModeType.ASYNCH_SERVER_SERVER, apId);
        SignatureRespType response = signaturePort.signatureSimpleDocument(request);
        log.info("Signature requested with transaction id " + response.getTransactionId() + ".");
        return response;
    }

    private static SignatureSimpleDocumentReqType prepareSimpleRequest(String identifier, String message, SignaturePolicyType policyType, boolean testMode, CertificateFiltersType certificateFilters, MessagingModeType messagingMode, Long apId) {
        MobileUserType mobileUser = new MobileUserType();
        mobileUser.setUniqueIdentifier(identifier);
        SignatureSimpleDocumentReqType request = new SignatureSimpleDocumentReqType();
        request.setDataToBeSigned(message);
        request.setMobileUser(mobileUser);
        request.setMessagingMode(messagingMode);
        request.setSignaturePolicy(policyType);
        request.setTestMode(testMode);
        request.setCertificateFilters(certificateFilters);
        request.setApId(apId.longValue());
        return request;
    }
}

