/*
 * Decompiled with CFR 0.152.
 */
package br.com.esec.icpm.libs.signature.helper;

import br.com.esec.icpm.libs.Server;
import br.com.esec.icpm.libs.signature.ApWsFactory;
import br.com.esec.icpm.libs.signature.BatchSignatureRequest;
import br.com.esec.icpm.mss.rest.ApplicationProviderResource;
import br.com.esec.icpm.mss.ws.BatchSignatureComplexDocumentReqType;
import br.com.esec.icpm.mss.ws.BatchSignatureComplexDocumentRespType;
import br.com.esec.icpm.mss.ws.HashDocumentInfoType;
import br.com.esec.icpm.mss.ws.MessagingModeType;
import br.com.esec.icpm.mss.ws.SignaturePortType;
import br.com.esec.icpm.mss.ws.SignatureStandardType;
import br.com.esec.icpm.server.ws.CertificateFiltersType;
import br.com.esec.icpm.server.ws.ICPMException;
import br.com.esec.icpm.server.ws.MobileUserType;
import br.com.esec.icpm.server.ws.SignaturePolicyType;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestBatchSignatureHelper {
    private static Logger log = LoggerFactory.getLogger(RequestBatchSignatureHelper.class);

    public static BatchSignatureComplexDocumentRespType requestSynchBatchSignature(Server server, String identifier, String message, SignatureStandardType standard, SignaturePolicyType policyType, boolean testMode, CertificateFiltersType certificateFilters, List<BatchSignatureRequest.Document> documents, Long apId) throws ICPMException {
        log.info("Requesting synch batch signature...");
        SignaturePortType signaturePort = ApWsFactory.getInstance().getSoapService(server);
        BatchSignatureComplexDocumentReqType request = RequestBatchSignatureHelper.prepareBachRequest(server, identifier, message, standard, policyType, testMode, certificateFilters, documents, MessagingModeType.SYNCH, apId);
        BatchSignatureComplexDocumentRespType response = signaturePort.batchSignatureComplexDocument(request);
        log.info("Signature requested with transaction id " + response.getTransactionId() + ".");
        return response;
    }

    public static BatchSignatureComplexDocumentRespType requestAsynchBatchSignature(Server server, String identifier, String message, SignatureStandardType standard, SignaturePolicyType policyType, boolean testMode, CertificateFiltersType certificateFilters, List<BatchSignatureRequest.Document> documents, Long apId) throws ICPMException {
        log.info("Requesting asynch batch signature...");
        SignaturePortType signaturePort = ApWsFactory.getInstance().getSoapService(server);
        BatchSignatureComplexDocumentReqType request = RequestBatchSignatureHelper.prepareBachRequest(server, identifier, message, standard, policyType, testMode, certificateFilters, documents, MessagingModeType.ASYNCH_CLIENT_SERVER, apId);
        BatchSignatureComplexDocumentRespType response = signaturePort.batchSignatureComplexDocument(request);
        log.info("Signature requested with transaction id " + response.getTransactionId() + ".");
        return response;
    }

    public static BatchSignatureComplexDocumentRespType requestAsynchWithNotifyBatchSignature(Server server, String identifier, String message, SignatureStandardType standard, SignaturePolicyType policyType, boolean testMode, CertificateFiltersType certificateFilters, List<BatchSignatureRequest.Document> documents, Long apId) throws ICPMException {
        log.info("Requesting asynch with notify batch signature...");
        SignaturePortType signaturePort = ApWsFactory.getInstance().getSoapService(server);
        BatchSignatureComplexDocumentReqType request = RequestBatchSignatureHelper.prepareBachRequest(server, identifier, message, standard, policyType, testMode, certificateFilters, documents, MessagingModeType.ASYNCH_SERVER_SERVER, apId);
        BatchSignatureComplexDocumentRespType response = signaturePort.batchSignatureComplexDocument(request);
        log.info("Signature requested with transaction id " + response.getTransactionId() + ".");
        return response;
    }

    private static BatchSignatureComplexDocumentReqType prepareBachRequest(Server server, String identifier, String message, SignatureStandardType standard, SignaturePolicyType policyType, boolean testMode, CertificateFiltersType certificateFilters, List<BatchSignatureRequest.Document> documents, MessagingModeType messagingMode, Long apId) {
        MobileUserType mobileUser = new MobileUserType();
        mobileUser.setUniqueIdentifier(identifier);
        BatchSignatureComplexDocumentReqType request = new BatchSignatureComplexDocumentReqType();
        request.setMobileUser(mobileUser);
        request.setMessagingMode(messagingMode);
        request.setDataToBeDisplayed(message);
        request.setSignatureStandard(standard);
        request.setSignaturePolicy(policyType);
        request.setTestMode(testMode);
        request.setCertificateFilters(certificateFilters);
        request.setApId(apId.longValue());
        List<HashDocumentInfoType> documentInfos = RequestBatchSignatureHelper.handleDocuments(server, documents);
        request.setDocumentsToBeSigned(documentInfos);
        return request;
    }

    private static List<HashDocumentInfoType> handleDocuments(Server server, List<BatchSignatureRequest.Document> documents) {
        ArrayList<HashDocumentInfoType> documentInfos = new ArrayList<HashDocumentInfoType>();
        for (BatchSignatureRequest.Document document : documents) {
            log.info("Uploading document '" + document.getName() + "'...");
            String hash = RequestBatchSignatureHelper.upload(server, document.getIn());
            log.info("Document '" + document.getName() + "' uploaded.");
            documentInfos.add(RequestBatchSignatureHelper.getDocumentInfo(hash, document.getName(), document.getMimeType()));
        }
        return documentInfos;
    }

    private static HashDocumentInfoType getDocumentInfo(String hash, String name, String mimeType) {
        HashDocumentInfoType document = new HashDocumentInfoType();
        document.setDocumentName(name);
        document.setHash(hash);
        document.setContentType(mimeType);
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String upload(Server server, InputStream in) {
        try {
            ApplicationProviderResource restService = ApWsFactory.getInstance().getRestService(server);
            String string = restService.uploadDocument(in);
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }
}

