/*
 * Decompiled with CFR 0.152.
 */
package br.com.esec.icpm.libs;

public class Server {
    public static final String DEFAULT_SOAP_WS_URI = "mss-ws/SignatureService/SignatureEndpointBean?wsdl";
    public static final String DEFAULT_REST_WS_URI = "mss/restful/";
    public static final Server PRODUCTION = new Server("api.certillion.com", true);
    public static final Server TEST = new Server("labs.certillion.com", false, "mss/serviceAp_prod.wsdl", "mss/restful/");
    private static final String URL_PATTERN = "%s://%s/%s";
    private final String host;
    private final boolean secure;
    private final String restWsUri;
    private final String soapWsUri;

    public Server(String host, boolean secure) {
        this.host = host;
        this.secure = secure;
        this.soapWsUri = DEFAULT_SOAP_WS_URI;
        this.restWsUri = DEFAULT_REST_WS_URI;
    }

    public Server(String host, boolean secure, String soapWsUri, String restWsUri) {
        this.host = host;
        this.secure = secure;
        this.soapWsUri = soapWsUri;
        this.restWsUri = restWsUri;
    }

    public String getHost() {
        return this.host;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String getRestWsUrl() {
        return String.format(URL_PATTERN, this.secure ? "https" : "http", this.host, this.restWsUri);
    }

    public String getSoapWsUrl() {
        return String.format(URL_PATTERN, this.secure ? "https" : "http", this.host, this.soapWsUri);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + (this.secure ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Server other = (Server)obj;
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        return this.secure == other.secure;
    }
}

