package br.com.esec.icpm.libs.signature.response.notify;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;

import br.com.esec.icpm.libs.Server;
import br.com.esec.icpm.libs.signature.response.Futures;
import br.com.esec.icpm.mss.ws.notification.BatchSignatureNotificationType;
import br.com.esec.icpm.mss.ws.notification.SignatureNotificationType;

/**
 * @author Tales Porto (tporto@esec.com.br|talesap@gmail.com)
 */
public class SignatureNotifier {
	
	private static Logger log = LoggerFactory.getLogger(SignatureNotifier.class);
	
	private Server server;

	public SignatureNotifier(Server server) {
		this.server = server;
	}

	public void simple(SignatureNotificationType notify) {
		log.info("Notificatifying batch signature  of transaction " + notify.getTransactionId() + "...");
		
		Long transactionId = notify.getTransactionId();
		ListenableFuture<SignatureNotificationType> future = Futures.get(server, transactionId);
		((SettableFuture<SignatureNotificationType>) future).set(notify);
		
		Futures.remove(server, transactionId);
	}

	public void batch(BatchSignatureNotificationType notify) {
		log.info("Notificatifying batch signature  of transaction " + notify.getTransactionId() + "...");
		
		Long transactionId = notify.getTransactionId();
		ListenableFuture<BatchSignatureNotificationType> future = Futures.get(server, transactionId);
		((SettableFuture<BatchSignatureNotificationType>) future).set(notify);
		
		Futures.remove(server, transactionId);
	}

}
