package br.com.esec.icpm.libs.signature.response.handler.batch;

import java.io.IOException;
import java.io.InputStream;
import java.util.Deque;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import br.com.esec.icpm.libs.Server;
import br.com.esec.icpm.mss.ws.BatchSignatureComplexDocumentRespType;
import br.com.esec.icpm.mss.ws.DocumentSignatureInfoType;
import br.com.esec.icpm.mss.ws.SignatureStandardType;
import br.com.esec.icpm.server.factory.Status;

/**
 * Response Batch Synchronous Signature Handler.
 * 
 * @author Tales Porto (tporto@esec.com.br|talesap@gmail.com)
 */
public class SignatureBatchSynchHandler extends BaseBatchSignatureHandler {

	private static Logger log = LoggerFactory.getLogger(SignatureBatchSynchHandler.class);

	public SignatureBatchSynchHandler(Server server, SignatureStandardType standard, BatchSignatureComplexDocumentRespType response) throws IOException {
		super(server, standard, response.getTransactionId());

		if (response.getStatus() != null) {
			statusCode = response.getStatus().getStatusCode();
			statusMessage = response.getStatus().getStatusMessage();
			if (statusCode != Status.REQUEST_OK.getCode()) {
				throw new IllegalStateException("Something bad happened. The signature response return eith status " + statusMessage + " (" + statusCode + ").");
			}
		}
		
		Deque<DocumentStatus> documentsStatus = getDocumentsStatus();
		List<DocumentSignatureInfoType> signatures = response.getSignatures();
		if (signatures != null) {
			for (DocumentSignatureInfoType docInfo : signatures) {
				final int statusCode = docInfo.getStatus().getStatusCode();
				final String statusMessage = docInfo.getStatus().getStatusMessage();
				final String name = docInfo.getDocumentName();

				InputStream signature = null;
				try {
					signature = parseSignature(statusCode, docInfo.getSignature());
				} catch (IOException e) {
					throw new IllegalStateException(e);
				}

				documentsStatus.add(new DocumentStatus(-1l, name, statusCode, statusMessage, signature));
			}
		}
	}


}
