package br.com.esec.icpm.libs.signature.response.handler.batch;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

import br.com.esec.icpm.libs.Server;
import br.com.esec.icpm.libs.signature.response.handler.SignatureAsynchHandler;
import br.com.esec.icpm.libs.signature.response.polling.BatchPollingService;
import br.com.esec.icpm.mss.ws.BatchSignatureTIDsRespType;
import br.com.esec.icpm.mss.ws.SignatureStandardType;
import br.com.esec.icpm.server.ws.ICPMException;

/**
 * Base Response Batch Asynchronous Signature Handler.
 * 
 * @author Tales Porto (tporto@esec.com.br|talesap@gmail.com)
 */
public abstract class BaseBatchAsynchSignatureHandler extends BaseBatchSignatureHandler implements SignatureAsynchHandler {

	public BaseBatchAsynchSignatureHandler(Server server, SignatureStandardType standard, long transactionId) {
		super(server, standard, transactionId);
	}

	public SignatureInfos waitForDocInfos() throws ICPMException, InterruptedException, TimeoutException {
		return waitForDocInfos(DEFAULT_TIMEOUT);
	}

	public SignatureInfos waitForDocInfos(long timeout) throws ICPMException, InterruptedException, TimeoutException {
		Future<BatchSignatureTIDsRespType> result = BatchPollingService.getInstance().status(server, transactionId, true);
		try {
			BatchSignatureTIDsRespType signatureStatusResp = result.get(timeout, TimeUnit.SECONDS);
			update(signatureStatusResp);
		} catch (TimeoutException e) {
			result.cancel(true);
			throw e;
		} catch (ExecutionException e) {
			throw new IllegalStateException(e);
		}

		return getDocInfos();
	}
	
}
