package br.com.esec.icpm.libs.signature.response.handler;

import java.util.concurrent.TimeoutException;

import br.com.esec.icpm.server.ws.ICPMException;

/**
 * Response Signature Asynchronous Handler.
 * 
 * @author Tales Porto (tporto@esec.com.br|talesap@gmail.com)
 */
public interface SignatureAsynchHandler extends SignatureHandler {

	long DEFAULT_TIMEOUT = 60; // 60s

	/**
	 * Block waiting to the response of the request signature. Use the {@link #DEFAULT_TIMEOUT}.
	 * 
	 * <p> Note: Differently of the synchronous method. This method block only the click thread waiting for a signature.
	 * 
	 * @return signature response asynch handler
	 * @throws ICPMException
	 * @throws InterruptedException
	 * @throws TimeoutException
	 */
	SignatureAsynchHandler waitTo() throws ICPMException, InterruptedException, TimeoutException;

	/**
	 * Block waiting to the response of the request signature.
	 * 
	 * <p> Note: Differently of the synchronous method. This method block only the client thread waiting for a signature.
	 * 
	 * @param timeout
	 * @return signature response asynch handler
	 * @throws ICPMException
	 * @throws InterruptedException
	 * @throws TimeoutException
	 */
	SignatureAsynchHandler waitTo(long timeout) throws ICPMException, InterruptedException, TimeoutException;

	/**
	 * Register a listener to notify when the signature arrive.
	 * 
	 * @param listener
	 * @return signature response asynch handler
	 * @throws ICPMException
	 * @throws InterruptedException
	 * @throws TimeoutException
	 */
	SignatureAsynchHandler addListener(Listener listener) throws ICPMException, InterruptedException, TimeoutException;

	public interface Listener {
		void onSuccess(SignatureAsynchHandler handler);
		void onFailed(Throwable e);
	}

}