package br.com.esec.icpm.libs.signature.response;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

/**
 * Thread pool size to threat back events of this library.
 * 
 * @author Tales Porto (tporto@esec.com.br|talesap@gmail.com)
 */
public class CertillionThreadPool {

	private static ScheduledExecutorService instance = Executors.newScheduledThreadPool(5);

	public static ScheduledExecutorService getInstance() {
		return instance;
	}

	/**
	 * Set the thread pool size to threat back events of this library.
	 * 
	 * DEFAULT: 5
	 * 
	 * @param corePoolSize
	 */
	public static synchronized void setThreadPoolSize(int corePoolSize) {
		if (corePoolSize == 0)
			return;

		ScheduledExecutorService oldInstance = instance; // save the old thread
															// pool instance
		instance = Executors.newScheduledThreadPool(corePoolSize); // create a
																	// new
																	// thread
																	// pool with
																	// the new
																	// value
		oldInstance.shutdown(); // kill the old thread pool
	}

}
