package br.com.esec.icpm.libs.signature.helper;

import java.lang.reflect.InvocationTargetException;

import org.apache.commons.lang.reflect.ConstructorUtils;

import br.com.esec.icpm.libs.signature.exceptions.InvalidSignatureException;
import br.com.esec.icpm.libs.signature.exceptions.RejectedSignatureException;
import br.com.esec.icpm.libs.signature.exceptions.SignatureException;
import br.com.esec.icpm.server.factory.Status;
import br.com.esec.icpm.server.ws.ICPMException;

public class CertillionExceptionHelper {

	public static void validateStatus(int statusCode, String statusMessage) throws SignatureException {
		validateStatus(-1, statusCode, statusMessage);
	}

	public static void validateStatus(long transactionId, int statusCode, String statusMessage)
			throws SignatureException {
		Class<? extends SignatureException> exceptionClass = getExceptionClass(statusCode);

		if (exceptionClass == null)
			return;

		throw safeInstantiateClass(exceptionClass, transactionId, statusCode, statusMessage);
	}

	public static SignatureException wrapICPMException(ICPMException e) {
		int statusCode = e.getFaultInfo().getStatusCode();
		String statusMessage = e.getFaultInfo().getStatusMessage();

		Class<? extends SignatureException> exceptionClass = getExceptionClass(statusCode);

		if (exceptionClass == null)
			throw new IllegalStateException("The status " + statusCode + " is not a error status.");

		return safeInstantiateClass(exceptionClass, statusCode, statusMessage, e);
	}

	private static Class<? extends SignatureException> getExceptionClass(int statusCode) {
		Status status = Status.getByCode(statusCode);

		if (!status.isError())
			return null;

		switch (status) {
		case SIGNATURE_INVALID:
			return InvalidSignatureException.class;
		case USER_CANCELED:
			return RejectedSignatureException.class;
		// TODO: Mapear os outros erros para exceções específicas na medida que for sendo necessário.
		default:
			return SignatureException.class;
		}
	}

	private static SignatureException safeInstantiateClass(Class<? extends SignatureException> exceptionClass,
			Object... params) {
		try {
			return (SignatureException) ConstructorUtils.invokeConstructor(exceptionClass, params);
		} catch (NoSuchMethodException e) {
			throw new IllegalStateException(e);
		} catch (IllegalAccessException e) {
			throw new IllegalStateException(e);
		} catch (InvocationTargetException e) {
			throw new IllegalStateException(e);
		} catch (InstantiationException e) {
			throw new IllegalStateException(e);
		}
	}
}
