package br.com.esec.icpm.libs.signature.exceptions;

import br.com.esec.icpm.server.ws.ICPMException;

/**
 * Generic exception to a signature. Check {@link #getStatusCode()}.
 * 
 * @author Tales Porto (tporto@esec.com.br|talesap@gmail.com)
 */
public class SignatureException extends Exception {

	private static final long serialVersionUID = 5464491471427277130L;

	private final int statusCode;
	private final long transactionId;
	private final String statusMessage;

	public SignatureException(int statusCode, String statusMessage) {
		this(statusCode, statusMessage, null);
	}

	public SignatureException(int statusCode, String statusMessage, ICPMException e) {
		this(-1, statusCode, statusMessage, e);
	}

	public SignatureException(long transactionId, int statusCode, String statusMessage) {
		this(transactionId, statusCode, statusMessage, null);
	}

	public SignatureException(long transactionId, int statusCode, String statusMessage, ICPMException e) {
		super("The signature '" + transactionId + "' return with status " + statusMessage + " (" + statusCode + ").");
		this.transactionId = transactionId;
		this.statusCode = statusCode;
		this.statusMessage = statusMessage;
	}

	public int getStatusCode() {
		return statusCode;
	}

	public long getTransactionId() {
		return transactionId;
	}

	public String getStatusMessage() {
		return statusMessage;
	}

}
