package br.com.esec.icpm.libs.signature;

import br.com.esec.icpm.server.ws.AlgorithmCertificateFilterType;
import br.com.esec.icpm.server.ws.AlgorithmType;
import br.com.esec.icpm.server.ws.CertificateFilterType;
import br.com.esec.icpm.server.ws.CertificateFiltersType;
import br.com.esec.icpm.server.ws.ForceHardwareFilterType;

/**
 * Advanced option to the signature.
 * 
 * @author Tales Porto (tporto@esec.com.br|talesap@gmail.com)
 */
public class SignatureOptions {

	CertificateFiltersType certificateFilters;

	/**
	 * Restrict the signature to only RSA signatures.
	 * 
	 * @return this
	 */
	public SignatureOptions onlyRsa() {
		addFilter(new AlgorithmCertificateFilterType(AlgorithmType.RSA));
		return this;
	}

	/**
	 * Restrict the signature to only ECDSA signatures.
	 * 
	 * @return this
	 */
	public SignatureOptions onlyEcdsa() {
		addFilter(new AlgorithmCertificateFilterType(AlgorithmType.ECC));
		return this;
	}

	/**
	 * Restrict the signature to only signatures on HARDWARE (A3).
	 * 
	 * @return this
	 */
	public SignatureOptions forceHardware() {
		addFilter(new ForceHardwareFilterType(true));
		return this;
	}

	/**
	 * Add another arbitrary filter.
	 * 
	 * @param filter
	 */
	private SignatureOptions addFilter(CertificateFilterType filter) {
		if (certificateFilters == null)
			certificateFilters = new CertificateFiltersType();
		certificateFilters.addFilter(filter);
		return this;
	}
}
