package br.com.esec.icpm.libs;

/**
 * @author Tales Porto (tporto@esec.com.br|talesap@gmail.com)
 */
public class Server {

	public static final String DEFAULT_SOAP_WS_URI = "mss-ws/SignatureService/SignatureEndpointBean?wsdl";
	public static final String DEFAULT_REST_WS_URI = "mss/restful/";

	public static final Server PRODUCTION = new Server("api.certillion.com", true);

	public static final Server TEST = new Server("labs.certillion.com", false, "mss/serviceAp_prod.wsdl",
			DEFAULT_REST_WS_URI);

	private static final String URL_PATTERN = "%s://%s/%s";

	private final String host;
	private final boolean secure;

	private final String restWsUri;
	private final String soapWsUri;

	public Server(String host, boolean secure) {
		this.host = host;
		this.secure = secure;
		this.soapWsUri = DEFAULT_SOAP_WS_URI;
		this.restWsUri = DEFAULT_REST_WS_URI;
	}

	public Server(String host, boolean secure, String soapWsUri, String restWsUri) {
		this.host = host;
		this.secure = secure;
		this.soapWsUri = soapWsUri;
		this.restWsUri = restWsUri;
	}

	public String getHost() {
		return host;
	}

	public boolean isSecure() {
		return secure;
	}

	public String getRestWsUrl() {
		return String.format(URL_PATTERN, secure ? "https" : "http", host, restWsUri);
	}

	public String getSoapWsUrl() {
		return String.format(URL_PATTERN, secure ? "https" : "http", host, soapWsUri);
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((host == null) ? 0 : host.hashCode());
		result = prime * result + (secure ? 1231 : 1237);
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Server other = (Server) obj;
		if (host == null) {
			if (other.host != null)
				return false;
		} else if (!host.equals(other.host))
			return false;
		if (secure != other.secure)
			return false;
		return true;
	}

	@Override
	public String toString() {
		return "Server [host=" + host + ", secure=" + secure + "]";
	}

}