package br.com.esec.icpm.libs;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import br.com.esec.icpm.signer.ws.rest.SslUtils;

/**
 * @author Tales Porto (tporto@esec.com.br|talesap@gmail.com)
 */
public class DefaultHttpClientBuilder implements HttpClientBuilder {

	private static Logger log = LoggerFactory.getLogger(DefaultHttpClientBuilder.class);

	@Override
	public Client getClient(Server server) {
		return getClientBuilder(server).build();
	}

	// HTTP cache builders

	private Map<Server, ClientBuilder> builders = new ConcurrentHashMap<Server, ClientBuilder>();

	private ClientBuilder getClientBuilder(Server server) {
		if (!builders.containsKey(server)) {
			// TODO: Acredito que deveria sincronizar no map para não construir
			// mais de um builder. O único beneficio seria uma leve melhora no
			// desempenho assim.
			// Create a builder
			log.info("Configuring a HTTP client builder to server " + server.getHost() + "...");

			ClientBuilder builder = ClientBuilder.newBuilder();

			if (server.isSecure())
				SslUtils.config(builder);
			builders.put(server, builder);
			log.info("HTTP client builder to server " + server.getHost() + " configured.");
		}
		return builders.get(server);
	}

}
