/*
 * Copyright (c) 2016 Certillion contributors
 * This program is made available under the terms of the Apache License.
 */
package br.com.esec.icpm.libs;

import java.security.Security;

import org.bouncycastle.jce.provider.BouncyCastleProvider;

import br.com.esec.icpm.libs.signature.SignatureRequest;
import br.com.esec.icpm.libs.signature.response.CertillionThreadPool;
import br.com.esec.icpm.libs.signature.response.download.SignatureDownloader;
import br.com.esec.icpm.libs.signature.response.notify.SignatureNotifier;

/**
 * <p align="left">
 * <img src="logo.png"/>
 * </p>
 * Certillion library make easy the integration of one java application with the
 * servers of Certillion.
 * <p />
 * 
 * <h3 id="1">1. First, config the library</h3>
 * 
 * <p>
 * You need to specify same inital parameters to use this library.
 * 
 * <p>
 * When you are testing, you can use the easy mode pointing to the test server.
 * 
 * <pre class="code">
 * <code class="java">
 * Certillion
 * 	.config() // Open config mode
 * 	.useTestServer() // Set to use TestServer
 * 	.done();
 * </code>
 * </pre>
 * 
 * <p>
 * When you are put on production, you can use the right mode pointing to the
 * production server.
 * 
 * <pre class="code">
 * <code class="java">
 * Certillion.config() // get configurable
 * 	.keystore().path("src/test/resources/valid-certificate-cnpj-12342841000101.p12") // set key store path
 * 	.keystore().type("PKCS12") // set key store type
 * 	.keystore().password("12345678") // set password
 * 	.done();
 * </code>
 * </pre>
 * 
 * <h3 id="2">2. Calling simple signature</h3> TODO
 * 
 * <h3 id="3">3. Calling batch signature</h3> TODO
 * 
 * <br />
 * 
 * @author Tales Porto (tporto@esec.com.br|talesap@gmail.com)
 */
public class Certillion {

	/**
	 * The server where the library make the calls.
	 */
	static Server server = Server.PRODUCTION;

	static {
		if (Security.getProvider(BouncyCastleProvider.PROVIDER_NAME) == null) {
			Security.addProvider(new BouncyCastleProvider());
		}
	}

	/**
	 * Get a config object to set some parameters.
	 * 
	 * @return a config object
	 */
	public static RootConfigurable config() {
		return new RootConfigurable();
	}

	/**
	 * Get a signature handle object to start a signature.
	 * 
	 * @return a signature handle object
	 */
	public static SignatureRequest signature() {
		return new SignatureRequest(server);
	}

	/**
	 * Get a signature notifier handle object to notify a event of signature
	 * received on your SOAP WS Endpoint.
	 * 
	 * @return a signature notifier handle object
	 */
	public static SignatureNotifier notifySignature() {
		return new SignatureNotifier(server);
	}

	/**
	 * Get a signature downloader. To download a signature any time.
	 * 
	 * @return a signature downloader object.
	 */
	public static SignatureDownloader downloadSignature() {
		return new SignatureDownloader(server);
	}

	/**
	 * Shutdown the library. (ThreadPool, ...)
	 */
	public static void shutdown() {
		CertillionThreadPool.getInstance().shutdown();
	}

}
