/*
 * Decompiled with CFR 0.152.
 */
package br.com.esec.icpm.libs.signature.response.notify;

import br.com.esec.icpm.libs.signature.response.Futures;
import br.com.esec.icpm.mss.ws.notification.BatchSignatureNotificationType;
import br.com.esec.icpm.mss.ws.notification.SignatureNotificationType;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureNotifier {
    private static Logger log = LoggerFactory.getLogger(SignatureNotifier.class);
    private String host;

    public SignatureNotifier(String host) {
        this.host = host;
    }

    public void simple(SignatureNotificationType notify) {
        log.info("Notificatifying batch signature  of transaction " + notify.getTransactionId() + "...");
        Long transactionId = notify.getTransactionId();
        ListenableFuture future = Futures.get(this.host, transactionId);
        ((SettableFuture)future).set((Object)notify);
        Futures.remove(this.host, transactionId);
    }

    public void batch(BatchSignatureNotificationType notify) {
        log.info("Notificatifying batch signature  of transaction " + notify.getTransactionId() + "...");
        Long transactionId = notify.getTransactionId();
        ListenableFuture future = Futures.get(this.host, transactionId);
        ((SettableFuture)future).set((Object)notify);
        Futures.remove(this.host, transactionId);
    }
}

