/*
 * Decompiled with CFR 0.152.
 */
package br.com.esec.icpm.libs.signature.response.handler;

import br.com.esec.icpm.libs.signature.exceptions.SignatureException;
import br.com.esec.icpm.libs.signature.response.ThreadPool;
import br.com.esec.icpm.libs.signature.response.handler.BaseSignatureHandler;
import br.com.esec.icpm.libs.signature.response.handler.SignatureAsynchHandler;
import br.com.esec.icpm.libs.signature.response.handler.SignatureHandler;
import br.com.esec.icpm.libs.signature.response.notify.NotifyService;
import br.com.esec.icpm.mss.ws.SignatureRespType;
import br.com.esec.icpm.mss.ws.notification.SignatureNotificationType;
import br.com.esec.icpm.server.ws.ICPMException;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureSimpleAsynchWithNotifyHandler
extends BaseSignatureHandler
implements SignatureAsynchHandler {
    private static Logger log = LoggerFactory.getLogger(SignatureSimpleAsynchWithNotifyHandler.class);
    private InputStream signature;
    private int statusCode;
    private String statusMessage;

    public SignatureSimpleAsynchWithNotifyHandler(String host, long transactionId) {
        super(host, transactionId);
    }

    public SignatureSimpleAsynchWithNotifyHandler(String host, SignatureRespType response) {
        super(host, response.getTransactionId());
        try {
            if (response.getStatus() != null) {
                this.statusCode = response.getStatus().getStatusCode();
                this.statusMessage = response.getStatus().getStatusMessage();
                this.signature = this.parseSignature(this.statusCode, response.getSignature());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public SignatureSimpleAsynchWithNotifyHandler waitTo() throws ICPMException, InterruptedException, TimeoutException {
        return this.waitTo(30L);
    }

    @Override
    public SignatureSimpleAsynchWithNotifyHandler waitTo(long timeout) throws ICPMException, InterruptedException, TimeoutException {
        ListenableFuture<SignatureNotificationType> result = NotifyService.getInstance().simple(this.host, this.transactionId);
        try {
            SignatureNotificationType signatureNotification = (SignatureNotificationType)result.get(timeout, TimeUnit.SECONDS);
            log.info("Simple signature arrived.");
            this.parseNotification(signatureNotification);
        }
        catch (TimeoutException e) {
            result.cancel(true);
            throw e;
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return this;
    }

    @Override
    public SignatureAsynchHandler addListener(final SignatureAsynchHandler.Listener listener) throws ICPMException, InterruptedException, TimeoutException {
        ListenableFuture<SignatureNotificationType> result = NotifyService.getInstance().simple(this.host, this.transactionId);
        Futures.addCallback(result, (FutureCallback)new FutureCallback<SignatureNotificationType>(){

            public void onSuccess(SignatureNotificationType signatureNotification) {
                try {
                    log.info("Batch signature arrived.");
                    SignatureSimpleAsynchWithNotifyHandler.this.parseNotification(signatureNotification);
                    listener.onSuccess(SignatureSimpleAsynchWithNotifyHandler.this);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }

            public void onFailure(Throwable t) {
                listener.onFailed(t);
            }
        }, (Executor)ThreadPool.instance);
        return this;
    }

    @Override
    public SignatureHandler save(OutputStream out) throws IOException, SignatureException {
        this.validateStatus(this.transactionId, this.statusCode, this.statusMessage);
        this.saveCades(out, this.signature);
        return this;
    }

    @Override
    public SignatureHandler save(InputStream in, OutputStream out) throws IOException, SignatureException {
        this.validateStatus(this.transactionId, this.statusCode, this.statusMessage);
        this.saveCades(in, out, this.signature);
        return this;
    }

    private void parseNotification(SignatureNotificationType signatureNotification) throws IOException {
        if (signatureNotification.getStatus() != null) {
            this.statusCode = signatureNotification.getStatus().getStatusCode();
            this.statusMessage = signatureNotification.getStatus().getStatusMessage();
            this.signature = this.parseSignature(this.statusCode, signatureNotification.getSignature());
        }
    }
}

