/*
 * Decompiled with CFR 0.152.
 */
package br.com.esec.icpm.libs.signature.response.handler;

import br.com.esec.icpm.libs.signature.response.handler.BaseBatchSignatureHandler;
import br.com.esec.icpm.mss.ws.BatchSignatureComplexDocumentRespType;
import br.com.esec.icpm.mss.ws.DocumentSignatureInfoType;
import br.com.esec.icpm.mss.ws.SignatureStandardType;
import br.com.esec.icpm.server.factory.Status;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureBatchSynchHandler
extends BaseBatchSignatureHandler {
    private static Logger log = LoggerFactory.getLogger(SignatureBatchSynchHandler.class);

    public SignatureBatchSynchHandler(String host, SignatureStandardType standard, BatchSignatureComplexDocumentRespType response) throws IOException {
        super(host, standard, response.getTransactionId());
        List signatures;
        if (response.getStatus() != null) {
            int statusCode = response.getStatus().getStatusCode();
            String statusMessage = response.getStatus().getStatusMessage();
            if (statusCode != Status.REQUEST_OK.getCode()) {
                throw new IllegalStateException("Something bad happened. The signature response return eith status " + statusMessage + " (" + statusCode + ").");
            }
        }
        if ((signatures = response.getSignatures()) != null) {
            for (DocumentSignatureInfoType docInfo : signatures) {
                int statusCode = docInfo.getStatus().getStatusCode();
                String statusMessage = docInfo.getStatus().getStatusMessage();
                String name = docInfo.getDocumentName();
                InputStream signature = null;
                try {
                    signature = this.parseSignature(statusCode, docInfo.getSignature());
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
                this.documentsStatus.add(new BaseBatchSignatureHandler.DocumentStatus(-1L, name, statusCode, statusMessage, signature));
            }
        }
    }
}

