/*
 * Decompiled with CFR 0.152.
 */
package br.com.esec.icpm.libs.signature.response.handler;

import br.com.esec.icpm.libs.signature.response.ThreadPool;
import br.com.esec.icpm.libs.signature.response.handler.BaseBatchAsynchSignatureHandler;
import br.com.esec.icpm.libs.signature.response.handler.SignatureAsynchHandler;
import br.com.esec.icpm.libs.signature.response.polling.BatchPollingService;
import br.com.esec.icpm.mss.ws.BatchSignatureComplexDocumentRespType;
import br.com.esec.icpm.mss.ws.BatchSignatureTIDsRespType;
import br.com.esec.icpm.mss.ws.SignatureStandardType;
import br.com.esec.icpm.server.factory.Status;
import br.com.esec.icpm.server.ws.ICPMException;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureBatchAsynchHandler
extends BaseBatchAsynchSignatureHandler
implements SignatureAsynchHandler {
    private static Logger log = LoggerFactory.getLogger(SignatureBatchAsynchHandler.class);

    public SignatureBatchAsynchHandler(String host, SignatureStandardType standard, BatchSignatureComplexDocumentRespType response) throws IOException {
        super(host, standard, response.getTransactionId());
        if (response.getStatus() != null) {
            int statusCode = response.getStatus().getStatusCode();
            String statusMessage = response.getStatus().getStatusMessage();
            if (statusCode != Status.REQUEST_OK.getCode()) {
                throw new IllegalStateException("Something bad happened. The signature response return eith status " + statusMessage + " (" + statusCode + ").");
            }
        }
    }

    public SignatureBatchAsynchHandler(String host, SignatureStandardType standard, long transactionId) {
        super(host, standard, transactionId);
    }

    @Override
    public SignatureBatchAsynchHandler waitTo() throws ICPMException, InterruptedException, TimeoutException {
        return this.waitTo(30L);
    }

    @Override
    public SignatureBatchAsynchHandler waitTo(long timeout) throws ICPMException, InterruptedException, TimeoutException {
        ListenableFuture<BatchSignatureTIDsRespType> result = BatchPollingService.getInstance().status(this.host, this.transactionId);
        try {
            BatchSignatureTIDsRespType signatureStatusResp = (BatchSignatureTIDsRespType)result.get(timeout, TimeUnit.SECONDS);
            log.info("Batch signature arrived.");
            this.documentsStatus = this.parseDocumentStatus(signatureStatusResp.getDocumentSignatureStatus());
        }
        catch (TimeoutException e) {
            result.cancel(true);
            throw e;
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
        return this;
    }

    @Override
    public SignatureAsynchHandler addListener(final SignatureAsynchHandler.Listener listener) throws ICPMException, InterruptedException, TimeoutException {
        ListenableFuture<BatchSignatureTIDsRespType> result = BatchPollingService.getInstance().status(this.host, this.transactionId, true);
        Futures.addCallback(result, (FutureCallback)new FutureCallback<BatchSignatureTIDsRespType>(){

            public void onSuccess(BatchSignatureTIDsRespType signatureStatus) {
                try {
                    log.info("Batch signature arrived.");
                    SignatureBatchAsynchHandler.this.documentsStatus = SignatureBatchAsynchHandler.this.parseDocumentStatus(signatureStatus.getDocumentSignatureStatus());
                    listener.onSuccess(SignatureBatchAsynchHandler.this);
                }
                catch (ICPMException e) {
                    throw new IllegalStateException(e);
                }
            }

            public void onFailure(Throwable t) {
                listener.onFailed(t);
            }
        }, (Executor)ThreadPool.instance);
        return this;
    }
}

