/*
 * Decompiled with CFR 0.152.
 */
package br.com.esec.icpm.libs.signature.response.handler;

import br.com.esec.icpm.libs.signature.exceptions.InvalidSignatureException;
import br.com.esec.icpm.libs.signature.exceptions.RejectedSignatureException;
import br.com.esec.icpm.libs.signature.exceptions.SignatureException;
import br.com.esec.icpm.libs.signature.helper.attach.CadesAttachSignatureHelper;
import br.com.esec.icpm.libs.signature.helper.attach.PdfAttachSignatureHelper;
import br.com.esec.icpm.libs.signature.helper.attach.XadesAttachSignatureHelper;
import br.com.esec.icpm.libs.signature.response.handler.SignatureHandler;
import br.com.esec.icpm.server.factory.Status;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataHandler;
import org.apache.commons.io.IOUtils;

public abstract class BaseSignatureHandler
implements SignatureHandler {
    protected long transactionId;
    protected String host;

    public BaseSignatureHandler(String host, long transactionId) {
        this.host = host;
        this.transactionId = transactionId;
    }

    protected void saveCades(OutputStream signedDocument, InputStream signature) throws IOException {
        IOUtils.copy((InputStream)signature, (OutputStream)signedDocument);
    }

    protected void saveCades(InputStream originalDocument, OutputStream signedDocument, InputStream signature) throws IOException {
        this.saveCades(this.transactionId, originalDocument, signedDocument, signature);
    }

    protected void saveXades(InputStream originalDocument, OutputStream signedDocument, InputStream signature) throws IOException {
        this.saveXades(this.transactionId, originalDocument, signedDocument, signature);
    }

    protected void saveAdobePdf(InputStream originalPdf, OutputStream signedPdf, InputStream signature) {
        this.saveAdobePdf(this.transactionId, originalPdf, signedPdf, signature);
    }

    protected void saveCades(long docId, InputStream originalDocument, OutputStream signedDocument, InputStream signature) throws IOException {
        CadesAttachSignatureHelper.attach(docId, originalDocument, signature, signedDocument);
    }

    protected void saveXades(long docId, InputStream originalDocument, OutputStream signedDocument, InputStream signature) throws IOException {
        XadesAttachSignatureHelper.attach(docId, originalDocument, signature, signedDocument);
    }

    protected void saveAdobePdf(long docId, InputStream originalPdf, OutputStream signedPdf, InputStream signature) {
        PdfAttachSignatureHelper.attach(docId, originalPdf, signature, signedPdf);
    }

    protected InputStream parseSignature(int statusCode, DataHandler signatureDataHandler) throws IOException {
        if (signatureDataHandler == null) {
            return null;
        }
        if (statusCode == Status.SIGNATURE_VALID.getCode() && signatureDataHandler != null) {
            return new ByteArrayInputStream(IOUtils.toByteArray((InputStream)signatureDataHandler.getInputStream()));
        }
        return null;
    }

    protected void validateStatus(long transactionId, int statusCode, String statusMessage) throws SignatureException {
        Status status = Status.getByCode((int)statusCode);
        if (!status.isError()) {
            return;
        }
        switch (status) {
            case SIGNATURE_INVALID: {
                throw new InvalidSignatureException(transactionId, statusCode, statusMessage);
            }
            case USER_CANCELED: {
                throw new RejectedSignatureException(transactionId, statusCode, statusMessage);
            }
        }
        throw new SignatureException(transactionId, statusCode, statusMessage);
    }
}

