/*
 * Decompiled with CFR 0.152.
 */
package br.com.esec.icpm.libs.signature.response.handler;

import br.com.esec.icpm.libs.signature.exceptions.SignatureException;
import br.com.esec.icpm.libs.signature.helper.RequestStatusHelper;
import br.com.esec.icpm.libs.signature.response.handler.BaseSignatureHandler;
import br.com.esec.icpm.libs.signature.response.handler.SignatureHandler;
import br.com.esec.icpm.mss.ws.DocumentSignatureStatusInfoType;
import br.com.esec.icpm.mss.ws.SignatureStandardType;
import br.com.esec.icpm.mss.ws.SignatureStatusRespType;
import br.com.esec.icpm.server.factory.Status;
import br.com.esec.icpm.server.ws.ICPMException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseBatchSignatureHandler
extends BaseSignatureHandler {
    private static Logger log = LoggerFactory.getLogger(BaseBatchSignatureHandler.class);
    protected SignatureStandardType standard;
    protected Deque<DocumentStatus> documentsStatus = new LinkedList<DocumentStatus>();

    public BaseBatchSignatureHandler(String host, SignatureStandardType standard, long transactionId) {
        super(host, transactionId);
        this.standard = standard;
    }

    @Override
    public SignatureHandler save(OutputStream out) throws IOException, SignatureException {
        block6: {
            DocumentStatus docStatus;
            block5: {
                docStatus = this.documentsStatus.removeFirst();
                log.info("Saving document signature of document '" + docStatus.getName() + "'.");
                this.validateStatus(this.transactionId, docStatus.getStatusCode(), docStatus.getStatusMesssage());
                if (docStatus.getStatusCode() != Status.SIGNATURE_VALID.getCode()) break block5;
                switch (this.standard) {
                    case CADES: {
                        this.saveCades(out, docStatus.getSignature());
                        break block6;
                    }
                    case ADOBEPDF: {
                        throw new IllegalStateException("Error. To save with AdobePdf we need the stream to original document again.");
                    }
                    case XADES: {
                        throw new IllegalStateException("Error. To save with XAdES we need the stream to original document again.");
                    }
                    default: {
                        throw new IllegalStateException("Standard '" + this.standard + "' is unrecognizable.");
                    }
                }
            }
            throw new IllegalStateException("The status " + docStatus.getStatusCode() + " is unrecognizable in this case.");
        }
        return this;
    }

    @Override
    public SignatureHandler save(InputStream in, OutputStream out) throws IOException, SignatureException {
        block6: {
            DocumentStatus docStatus;
            block5: {
                docStatus = this.documentsStatus.removeFirst();
                log.info("Saving document signature of document '" + docStatus.getName() + "'.");
                this.validateStatus(this.transactionId, docStatus.getStatusCode(), docStatus.getStatusMesssage());
                if (docStatus.getStatusCode() != Status.SIGNATURE_VALID.getCode()) break block5;
                switch (this.standard) {
                    case CADES: {
                        this.saveCades(docStatus.getDocId(), in, out, docStatus.getSignature());
                        break block6;
                    }
                    case ADOBEPDF: {
                        this.saveAdobePdf(docStatus.getDocId(), in, out, docStatus.getSignature());
                        break block6;
                    }
                    case XADES: {
                        this.saveXades(docStatus.getDocId(), in, out, docStatus.getSignature());
                        break block6;
                    }
                    default: {
                        throw new IllegalStateException("Standard '" + this.standard + "' is unrecognizable.");
                    }
                }
            }
            throw new IllegalStateException("The status " + docStatus.getStatusCode() + " is unrecognizable in this case.");
        }
        return this;
    }

    protected Deque<DocumentStatus> parseDocumentStatus(List<DocumentSignatureStatusInfoType> signatures) throws ICPMException {
        LinkedList<DocumentStatus> documentsStatus = new LinkedList<DocumentStatus>();
        for (DocumentSignatureStatusInfoType docStatusInfo : signatures) {
            long docId = docStatusInfo.getTransactionId();
            int statusCode = docStatusInfo.getStatus().getStatusCode();
            String statusMesssage = docStatusInfo.getStatus().getStatusMessage();
            String name = docStatusInfo.getDocumentName();
            InputStream signature = null;
            try {
                if (statusCode == Status.SIGNATURE_VALID.getCode()) {
                    SignatureStatusRespType status = RequestStatusHelper.requestStatus(this.host, docId);
                    signature = this.parseSignature(statusCode, status.getSignature());
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            documentsStatus.add(new DocumentStatus(docId, name, statusCode, statusMesssage, signature));
        }
        return documentsStatus;
    }

    public class DocumentStatus {
        private final long docId;
        private final String name;
        private final int statusCode;
        private final String statusMesssage;
        private final InputStream signature;

        public DocumentStatus(long docId, String name, int statusCode, String statusMesssage, InputStream signature) {
            this.docId = docId;
            this.name = name;
            this.statusCode = statusCode;
            this.statusMesssage = statusMesssage;
            this.signature = signature;
        }

        public String getName() {
            return this.name;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public InputStream getSignature() {
            return this.signature;
        }

        public long getDocId() {
            return this.docId;
        }

        public String getStatusMesssage() {
            return this.statusMesssage;
        }
    }
}

