/*
 * Decompiled with CFR 0.152.
 */
package br.com.esec.icpm.libs.signature.response.handler;

import br.com.esec.icpm.libs.signature.response.handler.BaseBatchSignatureHandler;
import br.com.esec.icpm.libs.signature.response.handler.SignatureAsynchHandler;
import br.com.esec.icpm.libs.signature.response.polling.BatchPollingService;
import br.com.esec.icpm.mss.ws.BatchSignatureTIDsRespType;
import br.com.esec.icpm.mss.ws.SignatureStandardType;
import br.com.esec.icpm.server.ws.ICPMException;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Deque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class BaseBatchAsynchSignatureHandler
extends BaseBatchSignatureHandler
implements SignatureAsynchHandler {
    public BaseBatchAsynchSignatureHandler(String host, SignatureStandardType standard, long transactionId) {
        super(host, standard, transactionId);
    }

    public SignatureInfos waitForDocInfos() throws ICPMException, InterruptedException, TimeoutException {
        return this.waitForDocInfos(30L);
    }

    public SignatureInfos waitForDocInfos(long timeout) throws ICPMException, InterruptedException, TimeoutException {
        ListenableFuture<BatchSignatureTIDsRespType> result = BatchPollingService.getInstance().status(this.host, this.transactionId, true);
        try {
            BatchSignatureTIDsRespType signatureStatusResp = (BatchSignatureTIDsRespType)result.get(timeout, TimeUnit.SECONDS);
            this.documentsStatus = this.parseDocumentStatus(signatureStatusResp.getDocumentSignatureStatus());
        }
        catch (TimeoutException e) {
            result.cancel(true);
            throw e;
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
        return new SignatureInfos(this.transactionId, this.documentsStatus);
    }

    public class SignatureInfos {
        private final long transactionId;
        private final Deque<BaseBatchSignatureHandler.DocumentStatus> documentsStatus;

        public SignatureInfos(long transactionId, Deque<BaseBatchSignatureHandler.DocumentStatus> documentsStatus) {
            this.transactionId = transactionId;
            this.documentsStatus = documentsStatus;
        }

        public long getTransactionId() {
            return this.transactionId;
        }

        public Deque<BaseBatchSignatureHandler.DocumentStatus> getDocumentsStatus() {
            return this.documentsStatus;
        }
    }
}

