/*
 * Decompiled with CFR 0.152.
 */
package br.com.esec.icpm.libs.signature.helper.attach;

import com.esec.signature.MakeExternalSignature;
import com.esec.text.DocumentException;
import com.esec.text.pdf.PdfReader;
import com.esec.text.pdf.PdfSignatureAppearance;
import com.esec.text.pdf.PdfStamper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.time.DateUtils;
import org.bouncycastle.asn1.ASN1UTCTime;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;

public class PdfAttachSignatureHelper {
    public static void attach(long transactionId, InputStream originalPdf, InputStream signature, OutputStream signedPdf) {
        try {
            PdfAttachSignatureHelper.attach(transactionId, originalPdf, IOUtils.toByteArray((InputStream)signature), signedPdf);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error when attach signature on original PDF.", e);
        }
    }

    public static void attach(long transactionId, InputStream originalPdf, byte[] signature, OutputStream signedPdf) {
        try {
            SignatureAttributes attributes = PdfAttachSignatureHelper.getSignatureAttributes(signature);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Certificate signerCert = cf.generateCertificate(new ByteArrayInputStream(attributes.getCertificateEncoded()));
            FileInputStream tempPDF = (FileInputStream)PdfAttachSignatureHelper.createSignedPDFStream(signerCert, originalPdf, signature, transactionId, attributes.getSignDate());
            IOUtils.copy((InputStream)tempPDF, (OutputStream)signedPdf);
        }
        catch (CMSException e) {
            throw new IllegalStateException("Error when attach signature on original PDF.", e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error when attach signature on original PDF.", e);
        }
        catch (CertificateException e) {
            throw new IllegalStateException("Error when attach signature on original PDF.", e);
        }
        catch (DocumentException e) {
            throw new IllegalStateException("Error when attach signature on original PDF.", e);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("Error when attach signature on original PDF.", e);
        }
    }

    public static InputStream createSignedPDFStream(Certificate signerCert, InputStream originalPdf, byte[] signature, long transactionId, Date signingTime) throws IOException, DocumentException, GeneralSecurityException, FileNotFoundException {
        File signedDoc = File.createTempFile("signed-" + transactionId, ".pdf");
        PdfReader reader = new PdfReader(originalPdf);
        PdfStamper stamper = PdfStamper.createSignature((PdfReader)reader, (OutputStream)FileUtils.openOutputStream((File)signedDoc), (char)'\u0000', null, (boolean)true);
        stamper.setDocumentId(transactionId);
        stamper.setModDate(DateUtils.toCalendar((Date)signingTime));
        PdfSignatureAppearance appearance = PdfAttachSignatureHelper.generateAppearance(stamper, signingTime);
        MakeExternalSignature.attachSignature((PdfSignatureAppearance)appearance, (Certificate)signerCert, (byte[])signature);
        return new FileInputStream(signedDoc);
    }

    protected static PdfSignatureAppearance generateAppearance(PdfStamper stamper, Date signingTime) {
        PdfSignatureAppearance appearance = stamper.getSignatureAppearance();
        appearance.setReason("Remote PDF Signer");
        appearance.setLocation("Certillion");
        appearance.setSignDate(DateUtils.toCalendar((Date)signingTime));
        return appearance;
    }

    public static SignatureAttributes getSignatureAttributes(byte[] signature) throws CMSException, IOException {
        SignatureAttributes attributes = new SignatureAttributes();
        CMSSignedData signedData = new CMSSignedData(signature);
        SignerInformationStore signerInfos = signedData.getSignerInfos();
        SignerInformation signerInfo = (SignerInformation)signerInfos.getSigners().iterator().next();
        if (signerInfo != null) {
            byte[] certificate = PdfAttachSignatureHelper.extractCertificate(signedData, signerInfo);
            Date signDate = PdfAttachSignatureHelper.extractDate(signerInfo);
            attributes.setCertificateEncoded(certificate);
            attributes.setSignDate(signDate);
            return attributes;
        }
        return null;
    }

    private static byte[] extractCertificate(CMSSignedData signedData, SignerInformation signerInfo) throws IOException {
        Store certStore = signedData.getCertificates();
        Collection certs = certStore.getMatches((Selector)signerInfo.getSID());
        Iterator iterator = certs.iterator();
        if (iterator.hasNext()) {
            X509CertificateHolder cert = (X509CertificateHolder)iterator.next();
            return cert.getEncoded();
        }
        return null;
    }

    private static Date extractDate(SignerInformation signerInfo) {
        try {
            Attribute signingTime = signerInfo.getSignedAttributes().get(CMSAttributes.signingTime);
            DERSet att = (DERSet)signingTime.getAttrValues();
            Enumeration atts = att.getObjects();
            while (atts.hasMoreElements()) {
                Object attribute = atts.nextElement();
                if (!(attribute instanceof ASN1UTCTime)) continue;
                ASN1UTCTime time = (ASN1UTCTime)attribute;
                Date date = time.getDate();
                return date;
            }
        }
        catch (ParseException e) {
            throw new IllegalStateException(e);
        }
        return null;
    }

    static class SignatureAttributes {
        private byte[] certificateEncoded;
        private Date signDate;

        SignatureAttributes() {
        }

        public byte[] getCertificateEncoded() {
            return this.certificateEncoded;
        }

        public void setCertificateEncoded(byte[] certificateEncoded) {
            this.certificateEncoded = certificateEncoded;
        }

        public Date getSignDate() {
            return this.signDate;
        }

        public void setSignDate(Date signDate) {
            this.signDate = signDate;
        }
    }
}

