/*
 * Decompiled with CFR 0.152.
 */
package br.com.esec.icpm.libs.signature.helper;

import br.com.esec.icpm.libs.signature.ApWsFactory;
import br.com.esec.icpm.libs.signature.BatchSignatureRequest;
import br.com.esec.icpm.mss.rest.ApplicationProviderResource;
import br.com.esec.icpm.mss.ws.BatchSignatureComplexDocumentReqType;
import br.com.esec.icpm.mss.ws.BatchSignatureComplexDocumentRespType;
import br.com.esec.icpm.mss.ws.HashDocumentInfoType;
import br.com.esec.icpm.mss.ws.MessagingModeType;
import br.com.esec.icpm.mss.ws.SignaturePortType;
import br.com.esec.icpm.mss.ws.SignatureStandardType;
import br.com.esec.icpm.server.ws.ICPMException;
import br.com.esec.icpm.server.ws.MobileUserType;
import br.com.esec.icpm.server.ws.SignaturePolicyType;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestBatchSignatureHelper {
    private static Logger log = LoggerFactory.getLogger(RequestBatchSignatureHelper.class);

    public static BatchSignatureComplexDocumentRespType requestSynchBatchSignature(String host, String identifier, String message, SignatureStandardType standard, SignaturePolicyType policyType, boolean testMode, List<BatchSignatureRequest.Document> documents) throws ICPMException {
        log.info("Requesting synch batch signature...");
        SignaturePortType signaturePort = ApWsFactory.getInstance().getSoapService(host);
        BatchSignatureComplexDocumentReqType request = RequestBatchSignatureHelper.prepareBachRequest(host, identifier, message, standard, policyType, testMode, documents, MessagingModeType.SYNCH);
        BatchSignatureComplexDocumentRespType response = signaturePort.batchSignatureComplexDocument(request);
        log.info("Signature requested with transaction id " + response.getTransactionId() + ".");
        return response;
    }

    public static BatchSignatureComplexDocumentRespType requestAsynchBatchSignature(String host, String identifier, String message, SignatureStandardType standard, SignaturePolicyType policyType, boolean testMode, List<BatchSignatureRequest.Document> documents) throws ICPMException {
        log.info("Requesting asynch batch signature...");
        SignaturePortType signaturePort = ApWsFactory.getInstance().getSoapService(host);
        BatchSignatureComplexDocumentReqType request = RequestBatchSignatureHelper.prepareBachRequest(host, identifier, message, standard, policyType, testMode, documents, MessagingModeType.ASYNCH_CLIENT_SERVER);
        BatchSignatureComplexDocumentRespType response = signaturePort.batchSignatureComplexDocument(request);
        log.info("Signature requested with transaction id " + response.getTransactionId() + ".");
        return response;
    }

    public static BatchSignatureComplexDocumentRespType requestAsynchWithNotifyBatchSignature(String host, String identifier, String message, SignatureStandardType standard, SignaturePolicyType policyType, boolean testMode, List<BatchSignatureRequest.Document> documents) throws ICPMException {
        log.info("Requesting asynch with notify batch signature...");
        SignaturePortType signaturePort = ApWsFactory.getInstance().getSoapService(host);
        BatchSignatureComplexDocumentReqType request = RequestBatchSignatureHelper.prepareBachRequest(host, identifier, message, standard, policyType, testMode, documents, MessagingModeType.ASYNCH_SERVER_SERVER);
        BatchSignatureComplexDocumentRespType response = signaturePort.batchSignatureComplexDocument(request);
        log.info("Signature requested with transaction id " + response.getTransactionId() + ".");
        return response;
    }

    private static BatchSignatureComplexDocumentReqType prepareBachRequest(String host, String identifier, String message, SignatureStandardType standard, SignaturePolicyType policyType, boolean testMode, List<BatchSignatureRequest.Document> documents, MessagingModeType messagingMode) {
        MobileUserType mobileUser = new MobileUserType();
        mobileUser.setUniqueIdentifier(identifier);
        BatchSignatureComplexDocumentReqType request = new BatchSignatureComplexDocumentReqType();
        request.setMobileUser(mobileUser);
        request.setMessagingMode(messagingMode);
        request.setDataToBeDisplayed(message);
        request.setSignatureStandard(standard);
        request.setSignaturePolicy(policyType);
        request.setTestMode(testMode);
        List<HashDocumentInfoType> documentInfos = RequestBatchSignatureHelper.handleDocuments(host, documents);
        request.setDocumentsToBeSigned(documentInfos);
        return request;
    }

    private static List<HashDocumentInfoType> handleDocuments(String host, List<BatchSignatureRequest.Document> documents) {
        ArrayList<HashDocumentInfoType> documentInfos = new ArrayList<HashDocumentInfoType>();
        for (BatchSignatureRequest.Document document : documents) {
            log.info("Uploading document '" + document.getName() + "'...");
            String hash = RequestBatchSignatureHelper.upload(host, document.getIn());
            log.info("Document '" + document.getName() + "' uploaded.");
            documentInfos.add(RequestBatchSignatureHelper.getDocumentInfo(hash, document.getName(), document.getMimeType()));
        }
        return documentInfos;
    }

    private static HashDocumentInfoType getDocumentInfo(String hash, String name, String mimeType) {
        HashDocumentInfoType document = new HashDocumentInfoType();
        document.setDocumentName(name);
        document.setHash(hash);
        document.setContentType(mimeType);
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String upload(String host, InputStream in) {
        try {
            ApplicationProviderResource restService = ApWsFactory.getInstance().getRestService(host);
            String string = restService.uploadDocument(in);
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }
}

