/*
 * Decompiled with CFR 0.152.
 */
package br.com.esec.icpm.libs.signature;

import br.com.esec.icpm.libs.signature.SignatureRequest;
import br.com.esec.icpm.libs.signature.helper.RequestSimpleSignatureHelper;
import br.com.esec.icpm.libs.signature.response.handler.SignatureSimpleAsynchHandler;
import br.com.esec.icpm.libs.signature.response.handler.SignatureSimpleAsynchWithNotifyHandler;
import br.com.esec.icpm.libs.signature.response.handler.SignatureSimpleSynchHandler;
import br.com.esec.icpm.mss.ws.SignatureRespType;
import br.com.esec.icpm.server.ws.ICPMException;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSignatureRequest {
    private static Logger log = LoggerFactory.getLogger(SimpleSignatureRequest.class);
    private SignatureRequest request;
    private String message;

    public SimpleSignatureRequest(SignatureRequest request) {
        this.request = request;
    }

    public SimpleSignatureRequest message(String message) {
        this.message = message;
        return this;
    }

    public SignatureSimpleSynchHandler sign() throws ICPMException, IOException {
        log.info("Requesting asynch batch signature to '" + this.request.identifier + "'.");
        SignatureRespType response = RequestSimpleSignatureHelper.requestSynchSimpleSignature(this.request.host, this.request.identifier, this.message, this.request.policyType, this.request.testMode);
        return new SignatureSimpleSynchHandler(this.request.host, response);
    }

    public SignatureSimpleAsynchHandler asynchSign() throws ICPMException, IOException {
        log.info("Requesting asynch batch signature to '" + this.request.identifier + "'.");
        SignatureRespType response = RequestSimpleSignatureHelper.requestAsynchSimpleSignature(this.request.host, this.request.identifier, this.message, this.request.policyType, this.request.testMode);
        return new SignatureSimpleAsynchHandler(this.request.host, response);
    }

    public SignatureSimpleAsynchWithNotifyHandler asynchSignWithNotify() throws ICPMException, IOException {
        log.info("Requesting asynch batch signature to '" + this.request.identifier + "'.");
        SignatureRespType response = RequestSimpleSignatureHelper.requestAsynchWithNotifySimpleSignature(this.request.host, this.request.identifier, this.message, this.request.policyType, this.request.testMode);
        return new SignatureSimpleAsynchWithNotifyHandler(this.request.host, response);
    }

    public SignatureSimpleAsynchHandler waitFor(long transactionId) throws ICPMException, InterruptedException, TimeoutException {
        return new SignatureSimpleAsynchHandler(this.request.host, transactionId).waitTo();
    }
}

