/*
 * Decompiled with CFR 0.152.
 */
package br.com.esec.icpm.libs.signature;

import br.com.esec.icpm.libs.signature.BatchSignatureRequest;
import br.com.esec.icpm.libs.signature.SimpleSignatureRequest;
import br.com.esec.icpm.server.ws.SignaturePolicyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureRequest {
    private static Logger log = LoggerFactory.getLogger(SignatureRequest.class);
    String identifier;
    boolean testMode;
    SignaturePolicyType policyType = SignaturePolicyType.AD_RB;
    String host;

    public SignatureRequest(String host) {
        this.host = host;
    }

    public SignatureRequest testMode() {
        this.testMode = true;
        return this;
    }

    public SignatureRequest toUser(String identifier) {
        this.identifier = identifier;
        return this;
    }

    public SimpleSignatureRequest simple() {
        return new SimpleSignatureRequest(this);
    }

    public BatchSignatureRequest batch() {
        return new BatchSignatureRequest(this);
    }

    public SignatureRequest adRb() {
        this.policyType = SignaturePolicyType.AD_RB;
        return this;
    }

    public SignatureRequest adRt() {
        this.policyType = SignaturePolicyType.AD_RT;
        return this;
    }

    public SignatureRequest adRc() {
        this.policyType = SignaturePolicyType.AD_RC;
        return this;
    }

    public SignatureRequest adRv() {
        this.policyType = SignaturePolicyType.AD_RV;
        return this;
    }

    public SignatureRequest adRa() {
        this.policyType = SignaturePolicyType.AD_RA;
        return this;
    }

    public SignatureRequest useHost(String host) {
        this.host = host;
        return this;
    }
}

